//	HYPE.documents["index"]

(function HYPE_DocumentLoader() {
	var resourcesFolderName = "index_Resources";
	var documentName = "index";
	var documentLoaderFilename = "index_hype_generated_script.js";

	// find the URL for this script's absolute path and set as the resourceFolderName
	try {
		var scripts = document.getElementsByTagName('script');
		for(var i = 0; i < scripts.length; i++) {
			var scriptSrc = scripts[i].src;
			if(scriptSrc != null && scriptSrc.indexOf(documentLoaderFilename) != -1) {
				resourcesFolderName = scriptSrc.substr(0, scriptSrc.lastIndexOf("/"));
				break;
			}
		}
	} catch(err) {	}

	// load HYPE.js if it hasn't been loaded yet
	if(typeof HYPE == "undefined") {
		if(typeof window.HYPE_DocumentsToLoad == "undefined") {
			window.HYPE_DocumentsToLoad = new Array();
			window.HYPE_DocumentsToLoad.push(HYPE_DocumentLoader);

			var headElement = document.getElementsByTagName('head')[0];
			var scriptElement = document.createElement('script');
			scriptElement.type= 'text/javascript';
			scriptElement.src = resourcesFolderName + '/' + 'HYPE.js';
			headElement.appendChild(scriptElement);
		} else {
			window.HYPE_DocumentsToLoad.push(HYPE_DocumentLoader);
		}
		return;
	}
	
	var attributeTransformerMapping = {"BorderColorRight":"ColorValueTransformer","BackgroundColor":"ColorValueTransformer","BorderWidthBottom":"PixelValueTransformer","WordSpacing":"PixelValueTransformer","BoxShadowXOffset":"PixelValueTransformer","Opacity":"FractionalValueTransformer","BorderWidthRight":"PixelValueTransformer","BorderWidthTop":"PixelValueTransformer","BoxShadowColor":"ColorValueTransformer","BorderColorBottom":"ColorValueTransformer","FontSize":"PixelValueTransformer","BorderRadiusTopRight":"PixelValueTransformer","TextColor":"ColorValueTransformer","Rotate":"DegreeValueTransformer","Height":"PixelValueTransformer","PaddingLeft":"PixelValueTransformer","BorderColorTop":"ColorValueTransformer","Top":"PixelValueTransformer","BackgroundGradientStartColor":"ColorValueTransformer","TextShadowXOffset":"PixelValueTransformer","PaddingTop":"PixelValueTransformer","BackgroundGradientAngle":"DegreeValueTransformer","PaddingBottom":"PixelValueTransformer","PaddingRight":"PixelValueTransformer","Width":"PixelValueTransformer","TextShadowColor":"ColorValueTransformer","BorderColorLeft":"ColorValueTransformer","ReflectionOffset":"PixelValueTransformer","Left":"PixelValueTransformer","BorderRadiusBottomRight":"PixelValueTransformer","LineHeight":"PixelValueTransformer","BoxShadowYOffset":"PixelValueTransformer","ReflectionDepth":"FractionalValueTransformer","BorderRadiusTopLeft":"PixelValueTransformer","BorderRadiusBottomLeft":"PixelValueTransformer","TextShadowBlurRadius":"PixelValueTransformer","TextShadowYOffset":"PixelValueTransformer","BorderWidthLeft":"PixelValueTransformer","BackgroundGradientEndColor":"ColorValueTransformer","BoxShadowBlurRadius":"PixelValueTransformer","LetterSpacing":"PixelValueTransformer"};

var scenes = [{"timelines":{"F612AA76-D1DD-41E0-80EE-A294C59E284B-233-000043AF6D1981CB_hover":{"framesPerSecond":30,"animations":[{"startValue":"0px","isRelative":true,"endValue":"0px","identifier":"TextShadowBlurRadius","duration":1,"timingFunction":"easeinout","type":0,"oid":"F612AA76-D1DD-41E0-80EE-A294C59E284B-233-000043AF6D1981CB","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"BackgroundGradientStartColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"F612AA76-D1DD-41E0-80EE-A294C59E284B-233-000043AF6D1981CB","startTime":0},{"startValue":"#333333","isRelative":true,"endValue":"#3C86D3","identifier":"TextColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"F612AA76-D1DD-41E0-80EE-A294C59E284B-233-000043AF6D1981CB","startTime":0},{"startValue":"1px","isRelative":true,"endValue":"2px","identifier":"TextShadowYOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"F612AA76-D1DD-41E0-80EE-A294C59E284B-233-000043AF6D1981CB","startTime":0},{"startValue":"0px","isRelative":true,"endValue":"1px","identifier":"TextShadowXOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"F612AA76-D1DD-41E0-80EE-A294C59E284B-233-000043AF6D1981CB","startTime":0},{"startValue":"#E6E6E6","isRelative":true,"endValue":"#EFEFEF","identifier":"BackgroundGradientEndColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"F612AA76-D1DD-41E0-80EE-A294C59E284B-233-000043AF6D1981CB","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"TextShadowColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"F612AA76-D1DD-41E0-80EE-A294C59E284B-233-000043AF6D1981CB","startTime":0}],"identifier":"F612AA76-D1DD-41E0-80EE-A294C59E284B-233-000043AF6D1981CB_hover","name":"F612AA76-D1DD-41E0-80EE-A294C59E284B-233-000043AF6D1981CB_hover","duration":1},"BA9C3DF8-7712-4855-9459-5AEA3EF3BFF0-233-000043AF6C557F0C_hover":{"framesPerSecond":30,"animations":[{"startValue":"0px","isRelative":true,"endValue":"0px","identifier":"TextShadowBlurRadius","duration":1,"timingFunction":"easeinout","type":0,"oid":"BA9C3DF8-7712-4855-9459-5AEA3EF3BFF0-233-000043AF6C557F0C","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"BackgroundGradientStartColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"BA9C3DF8-7712-4855-9459-5AEA3EF3BFF0-233-000043AF6C557F0C","startTime":0},{"startValue":"#333333","isRelative":true,"endValue":"#3C86D3","identifier":"TextColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"BA9C3DF8-7712-4855-9459-5AEA3EF3BFF0-233-000043AF6C557F0C","startTime":0},{"startValue":"1px","isRelative":true,"endValue":"2px","identifier":"TextShadowYOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"BA9C3DF8-7712-4855-9459-5AEA3EF3BFF0-233-000043AF6C557F0C","startTime":0},{"startValue":"0px","isRelative":true,"endValue":"1px","identifier":"TextShadowXOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"BA9C3DF8-7712-4855-9459-5AEA3EF3BFF0-233-000043AF6C557F0C","startTime":0},{"startValue":"#E6E6E6","isRelative":true,"endValue":"#EFEFEF","identifier":"BackgroundGradientEndColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"BA9C3DF8-7712-4855-9459-5AEA3EF3BFF0-233-000043AF6C557F0C","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"TextShadowColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"BA9C3DF8-7712-4855-9459-5AEA3EF3BFF0-233-000043AF6C557F0C","startTime":0}],"identifier":"BA9C3DF8-7712-4855-9459-5AEA3EF3BFF0-233-000043AF6C557F0C_hover","name":"BA9C3DF8-7712-4855-9459-5AEA3EF3BFF0-233-000043AF6C557F0C_hover","duration":1},"CB4090E3-FAF7-4519-831C-82C5B2AE336C-233-000043B8E35D1011_hover":{"framesPerSecond":30,"animations":[{"startValue":"0px","isRelative":true,"endValue":"0px","identifier":"TextShadowBlurRadius","duration":1,"timingFunction":"easeinout","type":0,"oid":"CB4090E3-FAF7-4519-831C-82C5B2AE336C-233-000043B8E35D1011","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"BackgroundGradientStartColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"CB4090E3-FAF7-4519-831C-82C5B2AE336C-233-000043B8E35D1011","startTime":0},{"startValue":"#333333","isRelative":true,"endValue":"#3C86D3","identifier":"TextColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"CB4090E3-FAF7-4519-831C-82C5B2AE336C-233-000043B8E35D1011","startTime":0},{"startValue":"1px","isRelative":true,"endValue":"2px","identifier":"TextShadowYOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"CB4090E3-FAF7-4519-831C-82C5B2AE336C-233-000043B8E35D1011","startTime":0},{"startValue":"0px","isRelative":true,"endValue":"1px","identifier":"TextShadowXOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"CB4090E3-FAF7-4519-831C-82C5B2AE336C-233-000043B8E35D1011","startTime":0},{"startValue":"#E6E6E6","isRelative":true,"endValue":"#EFEFEF","identifier":"BackgroundGradientEndColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"CB4090E3-FAF7-4519-831C-82C5B2AE336C-233-000043B8E35D1011","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"TextShadowColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"CB4090E3-FAF7-4519-831C-82C5B2AE336C-233-000043B8E35D1011","startTime":0}],"identifier":"CB4090E3-FAF7-4519-831C-82C5B2AE336C-233-000043B8E35D1011_hover","name":"CB4090E3-FAF7-4519-831C-82C5B2AE336C-233-000043B8E35D1011_hover","duration":1},"8FC1EFB2-AAE4-490F-8079-FD93FDF0E71F-233-000043AF6B848577_hover":{"framesPerSecond":30,"animations":[{"startValue":"0px","isRelative":true,"endValue":"0px","identifier":"TextShadowBlurRadius","duration":1,"timingFunction":"easeinout","type":0,"oid":"8FC1EFB2-AAE4-490F-8079-FD93FDF0E71F-233-000043AF6B848577","startTime":0},{"startValue":"#E6E6E6","isRelative":true,"endValue":"#EFEFEF","identifier":"BackgroundGradientStartColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"8FC1EFB2-AAE4-490F-8079-FD93FDF0E71F-233-000043AF6B848577","startTime":0},{"startValue":"#000000","isRelative":true,"endValue":"#000000","identifier":"TextColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"8FC1EFB2-AAE4-490F-8079-FD93FDF0E71F-233-000043AF6B848577","startTime":0},{"startValue":"1px","isRelative":true,"endValue":"2px","identifier":"TextShadowYOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"8FC1EFB2-AAE4-490F-8079-FD93FDF0E71F-233-000043AF6B848577","startTime":0},{"startValue":"0px","isRelative":true,"endValue":"1px","identifier":"TextShadowXOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"8FC1EFB2-AAE4-490F-8079-FD93FDF0E71F-233-000043AF6B848577","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"BackgroundGradientEndColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"8FC1EFB2-AAE4-490F-8079-FD93FDF0E71F-233-000043AF6B848577","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"TextShadowColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"8FC1EFB2-AAE4-490F-8079-FD93FDF0E71F-233-000043AF6B848577","startTime":0}],"identifier":"8FC1EFB2-AAE4-490F-8079-FD93FDF0E71F-233-000043AF6B848577_hover","name":"8FC1EFB2-AAE4-490F-8079-FD93FDF0E71F-233-000043AF6B848577_hover","duration":1},"8C3C9F19-0A6E-4ACB-9F41-610CE27A4E51-233-000043AF6DDE4D4A_hover":{"framesPerSecond":30,"animations":[{"startValue":"0px","isRelative":true,"endValue":"0px","identifier":"TextShadowBlurRadius","duration":1,"timingFunction":"easeinout","type":0,"oid":"8C3C9F19-0A6E-4ACB-9F41-610CE27A4E51-233-000043AF6DDE4D4A","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"BackgroundGradientStartColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"8C3C9F19-0A6E-4ACB-9F41-610CE27A4E51-233-000043AF6DDE4D4A","startTime":0},{"startValue":"#333333","isRelative":true,"endValue":"#3C86D3","identifier":"TextColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"8C3C9F19-0A6E-4ACB-9F41-610CE27A4E51-233-000043AF6DDE4D4A","startTime":0},{"startValue":"1px","isRelative":true,"endValue":"2px","identifier":"TextShadowYOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"8C3C9F19-0A6E-4ACB-9F41-610CE27A4E51-233-000043AF6DDE4D4A","startTime":0},{"startValue":"0px","isRelative":true,"endValue":"1px","identifier":"TextShadowXOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"8C3C9F19-0A6E-4ACB-9F41-610CE27A4E51-233-000043AF6DDE4D4A","startTime":0},{"startValue":"#E6E6E6","isRelative":true,"endValue":"#EFEFEF","identifier":"BackgroundGradientEndColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"8C3C9F19-0A6E-4ACB-9F41-610CE27A4E51-233-000043AF6DDE4D4A","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"TextShadowColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"8C3C9F19-0A6E-4ACB-9F41-610CE27A4E51-233-000043AF6DDE4D4A","startTime":0}],"identifier":"8C3C9F19-0A6E-4ACB-9F41-610CE27A4E51-233-000043AF6DDE4D4A_hover","name":"8C3C9F19-0A6E-4ACB-9F41-610CE27A4E51-233-000043AF6DDE4D4A_hover","duration":1},"kTimelineDefaultIdentifier":{"framesPerSecond":30,"animations":[],"identifier":"kTimelineDefaultIdentifier","name":"Main Timeline","duration":0},"E0A49A27-3235-44D2-8DF2-ADD860A2995D-73864-000151558CA3CEC5_hover":{"framesPerSecond":30,"animations":[{"startValue":"#FFFFFF","isRelative":true,"endValue":"#D8D8D8","identifier":"BackgroundGradientStartColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"E0A49A27-3235-44D2-8DF2-ADD860A2995D-73864-000151558CA3CEC5","startTime":0},{"startValue":"#D8D8D8","isRelative":true,"endValue":"#FFFFFF","identifier":"BackgroundGradientEndColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"E0A49A27-3235-44D2-8DF2-ADD860A2995D-73864-000151558CA3CEC5","startTime":0},{"startValue":"1px","isRelative":true,"endValue":"0px","identifier":"BoxShadowYOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"E0A49A27-3235-44D2-8DF2-ADD860A2995D-73864-000151558CA3CEC5","startTime":0},{"startValue":"3px","isRelative":true,"endValue":"0px","identifier":"BoxShadowBlurRadius","duration":1,"timingFunction":"easeinout","type":0,"oid":"E0A49A27-3235-44D2-8DF2-ADD860A2995D-73864-000151558CA3CEC5","startTime":0}],"identifier":"E0A49A27-3235-44D2-8DF2-ADD860A2995D-73864-000151558CA3CEC5_hover","name":"E0A49A27-3235-44D2-8DF2-ADD860A2995D-73864-000151558CA3CEC5_hover","duration":1}},"id":"63312270-7D17-479F-A107-D656370C794D-73864-00015045950F244D","sceneIndex":0,"perspective":"600px","oid":"63312270-7D17-479F-A107-D656370C794D-73864-00015045950F244D","initialValues":{"CEC49235-17EC-477F-9515-A2841FDB0399-73864-00015090AE250AFA":{"BorderWidthLeft":"1px","TagName":"div","BorderColorBottom":"#A0A0A0","BorderStyleRight":"Solid","BorderStyleBottom":"Solid","BoxShadowBlurRadius":"5px","Top":"23px","BorderStyleLeft":"Solid","BorderWidthRight":"1px","BorderColorTop":"#A0A0A0","BorderColorLeft":"#A0A0A0","BoxShadowYOffset":"0px","UserSelect":"none","Position":"absolute","Height":"569px","Left":"31px","BoxShadowColor":"#959595","BorderColorRight":"#A0A0A0","BorderStyleTop":"Solid","BorderRadiusTopLeft":"10px","ZIndex":"1","Width":"858px","BorderWidthTop":"1px","BoxShadowXOffset":"0px","BorderRadiusBottomLeft":"10px","BorderRadiusTopRight":"10px","Overflow":"visible","BorderRadiusBottomRight":"10px","BorderWidthBottom":"1px","BackgroundColor":"#FFFFFF"},"8FC1EFB2-AAE4-490F-8079-FD93FDF0E71F-233-000043AF6B848577":{"BorderStyleTop":"Solid","BorderStyleRight":"Solid","BackgroundColor":"#F0F0F0","WordWrap":"break-word","FontWeight":"normal","Display":"inline","BorderWidthBottom":"1px","BorderWidthRight":"1px","BorderWidthTop":"1px","ButtonHover":"8FC1EFB2-AAE4-490F-8079-FD93FDF0E71F-233-000043AF6B848577_hover","BorderStyleLeft":"Solid","BorderColorBottom":"#B3B3B3","FontSize":"14px","TextColor":"#000000","InnerHTML":"Welcome to&nbsp;<div>Raven for Mac</div>","Height":"36px","TextAlign":"left","ZIndex":"8","PaddingLeft":"14px","Top":"528px","BackgroundGradientStartColor":"#E6E6E6","UserSelect":"none","WhiteSpaceCollapsing":"preserve","TextShadowXOffset":"0px","BorderColorTop":"#B3B3B3","PaddingTop":"14px","TagName":"div","BorderStyleBottom":"Solid","BackgroundGradientAngle":"0deg","PaddingBottom":"14px","FontFamily":"'Helvetica Neue',Arial,Helvetica,Sans-Serif","PaddingRight":"14px","Position":"absolute","TextShadowColor":"#FFFFFF","Width":"139px","BorderColorLeft":"#B3B3B3","BorderRadiusBottomRight":"0px","Left":"31px","BorderColorRight":"#B3B3B3","BorderRadiusBottomLeft":"10px","BorderWidthLeft":"1px","TextShadowBlurRadius":"0px","TextShadowYOffset":"1px","Cursor":"pointer","BackgroundGradientEndColor":"#FFFFFF","Overflow":"visible","LetterSpacing":"0px"},"BA9C3DF8-7712-4855-9459-5AEA3EF3BFF0-233-000043AF6C557F0C":{"ActionOnMouseClick":{"type":1,"transition":1,"sceneOid":"62A7DFA9-2B38-49E6-9694-0E4FE9F8B2E8-233-000044404F9F937D"},"BorderStyleTop":"Solid","BackgroundColor":"#F0F0F0","WordWrap":"break-word","FontWeight":"normal","Display":"inline","BorderStyleRight":"Solid","BorderWidthBottom":"1px","BorderWidthRight":"1px","BorderWidthTop":"1px","ButtonHover":"BA9C3DF8-7712-4855-9459-5AEA3EF3BFF0-233-000043AF6C557F0C_hover","BorderStyleLeft":"Solid","BorderColorBottom":"#B3B3B3","FontSize":"14px","TextColor":"#333333","InnerHTML":"<div>Build Your Web</div><div>App Library</div>","Height":"36px","TextAlign":"left","ZIndex":"9","PaddingLeft":"14px","Top":"528px","BackgroundGradientStartColor":"#FFFFFF","UserSelect":"none","WhiteSpaceCollapsing":"preserve","TextShadowXOffset":"0px","BorderColorTop":"#B3B3B3","PaddingTop":"14px","TagName":"div","BorderStyleBottom":"Solid","BackgroundGradientAngle":"0deg","PaddingBottom":"14px","FontFamily":"'Helvetica Neue',Arial,Helvetica,Sans-Serif","PaddingRight":"14px","Position":"absolute","TextShadowColor":"#FFFFFF","Width":"130px","BorderColorLeft":"#B3B3B3","BorderRadiusBottomRight":"0px","Left":"192px","BorderColorRight":"#B3B3B3","BorderRadiusBottomLeft":"0px","BorderWidthLeft":"1px","TextShadowBlurRadius":"0px","TextShadowYOffset":"1px","Cursor":"pointer","BackgroundGradientEndColor":"#E6E6E6","Overflow":"visible","LetterSpacing":"0px"},"B58F7D5E-5F2C-4902-AA90-A43F02F19617-73864-00015105FF1F3E65":{"FontFamily":"'Helvetica Neue',Arial,Helvetica,Sans-Serif","TagName":"div","PaddingRight":"8px","FontSize":"17px","Display":"inline","WordWrap":"break-word","PaddingBottom":"8px","Top":"189px","UserSelect":"none","WhiteSpaceCollapsing":"preserve","Position":"absolute","Height":"183px","Left":"74px","InnerHTML":"Meet Raven. A web browser that takes your favorite web apps to a whole new level.<div><br></div><div>The new Smart Bar\u2122 allows you to quickly flip between your apps effortlessly like switching channels.</div><div><br></div><div>You can preview our new Web App Shop\u2122 and discover new sites to bookmark.</div>","ZIndex":"5","Width":"339px","PaddingLeft":"8px","PaddingTop":"8px","Overflow":"visible","TextColor":"#666666"},"377518D7-A904-4DC2-AEB9-5EB9520FDB48-73864-00015173AF680566":{"Position":"absolute","BackgroundOrigin":"content-box","Display":"inline","UserSelect":"none","BackgroundImage":"arrow.png","Left":"287px","Cursor":"pointer","Overflow":"visible","BackgroundSize":"100% 100%","ZIndex":"7","Height":"15px","ActionOnMouseClick":{"goToURL":"http://start.raven.io","type":5,"openInNewWindow":false},"Width":"15px","Top":"419px","TagName":"div"},"056DE3AE-F6B7-4746-A12F-14DD11DF2B2C-233-00004412D8B735E0":{"Position":"absolute","BoxShadowXOffset":"0px","BackgroundOrigin":"content-box","Display":"inline","UserSelect":"none","BackgroundImage":"macbook.png","Left":"400px","BoxShadowBlurRadius":"0px","Height":"547px","Overflow":"visible","BackgroundSize":"100% 100%","ZIndex":"2","BoxShadowColor":"#000000","BackgroundRepeat":"no-repeat","BoxShadowYOffset":"0px","Width":"490px","Top":"29px","InnerHTML":"","TagName":"div"},"8C3C9F19-0A6E-4ACB-9F41-610CE27A4E51-233-000043AF6DDE4D4A":{"ActionOnMouseClick":{"type":1,"transition":1,"sceneOid":"D31FB37E-5520-48E5-A0C3-6F9BA7834791-233-00004BCF153486D2"},"BorderStyleTop":"Solid","BackgroundColor":"#F0F0F0","WordWrap":"break-word","FontWeight":"normal","Display":"inline","BorderStyleRight":"Solid","BorderWidthBottom":"1px","BorderWidthRight":"1px","BorderWidthTop":"1px","ButtonHover":"8C3C9F19-0A6E-4ACB-9F41-610CE27A4E51-233-000043AF6DDE4D4A_hover","BorderStyleLeft":"Solid","BorderColorBottom":"#B3B3B3","FontSize":"14px","TextColor":"#333333","InnerHTML":"Visting the<div>Web App Shop</div>","Height":"36px","TextAlign":"left","ZIndex":"11","PaddingLeft":"14px","Top":"528px","BackgroundGradientStartColor":"#FFFFFF","UserSelect":"none","WhiteSpaceCollapsing":"preserve","TextShadowXOffset":"0px","BorderColorTop":"#B3B3B3","PaddingTop":"14px","TagName":"div","BorderStyleBottom":"Solid","BackgroundGradientAngle":"0deg","PaddingBottom":"14px","FontFamily":"'Helvetica Neue',Arial,Helvetica,Sans-Serif","PaddingRight":"14px","Position":"absolute","TextShadowColor":"#FFFFFF","Width":"160px","BorderColorLeft":"#B3B3B3","BorderRadiusBottomRight":"10px","Left":"701px","BorderColorRight":"#B3B3B3","BorderRadiusBottomLeft":"0px","BorderWidthLeft":"1px","TextShadowBlurRadius":"0px","TextShadowYOffset":"1px","Cursor":"pointer","BackgroundGradientEndColor":"#E6E6E6","Overflow":"visible","LetterSpacing":"0px"},"F612AA76-D1DD-41E0-80EE-A294C59E284B-233-000043AF6D1981CB":{"ActionOnMouseClick":{"type":1,"transition":1,"sceneOid":"E5C5FC9B-874F-4B52-8BAA-0CE133341F42-233-000049C968DF1C30"},"BorderStyleTop":"Solid","BackgroundColor":"#F0F0F0","WordWrap":"break-word","FontWeight":"normal","Display":"inline","BorderStyleRight":"Solid","BorderWidthBottom":"1px","BorderWidthRight":"1px","BorderWidthTop":"1px","ButtonHover":"F612AA76-D1DD-41E0-80EE-A294C59E284B-233-000043AF6D1981CB_hover","BorderStyleLeft":"Solid","BorderColorBottom":"#B3B3B3","FontSize":"14px","TextColor":"#333333","InnerHTML":"Adding Favorites<div>&amp; Bookmarks</div>","Height":"36px","TextAlign":"left","ZIndex":"10","PaddingLeft":"14px","Top":"528px","BackgroundGradientStartColor":"#FFFFFF","UserSelect":"none","WhiteSpaceCollapsing":"preserve","TextShadowXOffset":"0px","BorderColorTop":"#B3B3B3","PaddingTop":"14px","TagName":"div","BorderStyleBottom":"Solid","BackgroundGradientAngle":"0deg","PaddingBottom":"14px","FontFamily":"'Helvetica Neue',Arial,Helvetica,Sans-Serif","PaddingRight":"14px","Position":"absolute","TextShadowColor":"#FFFFFF","Width":"146px","BorderColorLeft":"#B3B3B3","BorderRadiusBottomRight":"0px","Left":"351px","BorderColorRight":"#B3B3B3","BorderRadiusBottomLeft":"0px","BorderWidthLeft":"1px","TextShadowBlurRadius":"0px","TextShadowYOffset":"1px","Cursor":"pointer","BackgroundGradientEndColor":"#E6E6E6","Overflow":"visible","LetterSpacing":"0px"},"CB4090E3-FAF7-4519-831C-82C5B2AE336C-233-000043B8E35D1011":{"ActionOnMouseClick":{"type":1,"transition":1,"sceneOid":"1952F16F-11C6-44E6-8C53-F6B4588C2F70-233-0000473500C5B081"},"BorderStyleTop":"Solid","BackgroundColor":"#F0F0F0","WordWrap":"break-word","FontWeight":"normal","Display":"inline","BorderStyleRight":"Solid","BorderWidthBottom":"1px","BorderWidthRight":"1px","BorderWidthTop":"1px","ButtonHover":"CB4090E3-FAF7-4519-831C-82C5B2AE336C-233-000043B8E35D1011_hover","BorderStyleLeft":"Solid","BorderColorBottom":"#B3B3B3","FontSize":"14px","TextColor":"#333333","InnerHTML":"<span class=\"Apple-style-span\" style=\"color: rgb(0, 0, 0); \">Browsing your<div style=\"-webkit-transform: rotateY(0deg); \">Bookmarks</div></span>","Height":"36px","TextAlign":"left","ZIndex":"12","PaddingLeft":"14px","Top":"528px","BackgroundGradientStartColor":"#FFFFFF","UserSelect":"none","WhiteSpaceCollapsing":"preserve","TextShadowXOffset":"0px","BorderColorTop":"#B3B3B3","PaddingTop":"14px","TagName":"div","BorderStyleBottom":"Solid","BackgroundGradientAngle":"0deg","PaddingBottom":"14px","FontFamily":"'Helvetica Neue',Arial,Helvetica,Sans-Serif","PaddingRight":"14px","Position":"absolute","TextShadowColor":"#FFFFFF","Width":"146px","BorderColorLeft":"#B3B3B3","BorderRadiusBottomRight":"0px","Left":"526px","BorderColorRight":"#B3B3B3","BorderRadiusBottomLeft":"0px","BorderWidthLeft":"1px","TextShadowBlurRadius":"0px","TextShadowYOffset":"1px","Cursor":"pointer","BackgroundGradientEndColor":"#E6E6E6","Overflow":"visible","LetterSpacing":"0px"},"E0A49A27-3235-44D2-8DF2-ADD860A2995D-73864-000151558CA3CEC5":{"PaddingBottom":"10px","BorderWidthLeft":"1px","Display":"inline","TagName":"div","BorderColorLeft":"#A0A0A0","UserSelect":"none","Overflow":"visible","TextAlign":"left","LineHeight":"17px","BoxShadowBlurRadius":"3px","BorderColorTop":"#A0A0A0","BackgroundGradientAngle":"0deg","ActionOnMouseClick":{"goToURL":"http://start.raven.io","type":5,"openInNewWindow":false},"BorderWidthBottom":"1px","WordSpacing":"0px","BorderStyleRight":"Solid","ZIndex":"6","BorderRadiusBottomRight":"6px","FontSize":"16px","BackgroundGradientStartColor":"#FFFFFF","Width":"209px","TextShadowXOffset":"0px","BorderColorRight":"#A0A0A0","BoxShadowColor":"#AFAFAF","PaddingLeft":"10px","BoxShadowXOffset":"0px","BorderColorBottom":"#A0A0A0","BoxShadowYOffset":"1px","Cursor":"pointer","Position":"absolute","BorderStyleTop":"Solid","TextShadowColor":"#FFFFFF","BorderRadiusBottomLeft":"6px","BorderRadiusTopLeft":"6px","Left":"84px","BorderRadiusTopRight":"6px","BorderStyleBottom":"Solid","Height":"20px","PaddingRight":"10px","FontWeight":"bold","WhiteSpaceCollapsing":"preserve","PaddingTop":"10px","BackgroundColor":"#F0F0F0","TextColor":"#0051A1","BorderWidthTop":"1px","Top":"404px","TextShadowBlurRadius":"0px","TextShadowYOffset":"1px","InnerHTML":"Visit the Web App Shop","WordWrap":"break-word","BackgroundGradientEndColor":"#D8D8D8","BorderStyleLeft":"Solid","BorderWidthRight":"1px","ButtonHover":"E0A49A27-3235-44D2-8DF2-ADD860A2995D-73864-000151558CA3CEC5_hover"},"7E255F0F-9194-4E74-B98B-986C5C4390E8-73864-000150EFAA1D8109":{"FontFamily":"Helvetica,Arial,Sans-Serif","FontWeight":"normal","TagName":"div","PaddingRight":"8px","FontSize":"48px","LetterSpacing":"-2px","Display":"inline","WordWrap":"break-word","PaddingBottom":"8px","Top":"116px","UserSelect":"none","WhiteSpaceCollapsing":"preserve","Position":"absolute","Height":"46px","Left":"74px","InnerHTML":"Welcome...","ZIndex":"4","PaddingLeft":"8px","Width":"339px","PaddingTop":"8px","Overflow":"visible","TextColor":"#000000"}},"name":"Welcome","backgroundColor":"#E2E4E2"},{"timelines":{"DFB40D7C-35C3-43FD-84E5-723B9056070F-233-000044404EC63C33_hover":{"framesPerSecond":30,"animations":[{"startValue":"0px","isRelative":true,"endValue":"0px","identifier":"TextShadowBlurRadius","duration":1,"timingFunction":"easeinout","type":0,"oid":"DFB40D7C-35C3-43FD-84E5-723B9056070F-233-000044404EC63C33","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"BackgroundGradientStartColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"DFB40D7C-35C3-43FD-84E5-723B9056070F-233-000044404EC63C33","startTime":0},{"startValue":"#333333","isRelative":true,"endValue":"#3C86D3","identifier":"TextColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"DFB40D7C-35C3-43FD-84E5-723B9056070F-233-000044404EC63C33","startTime":0},{"startValue":"1px","isRelative":true,"endValue":"2px","identifier":"TextShadowYOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"DFB40D7C-35C3-43FD-84E5-723B9056070F-233-000044404EC63C33","startTime":0},{"startValue":"0px","isRelative":true,"endValue":"1px","identifier":"TextShadowXOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"DFB40D7C-35C3-43FD-84E5-723B9056070F-233-000044404EC63C33","startTime":0},{"startValue":"#E6E6E6","isRelative":true,"endValue":"#EFEFEF","identifier":"BackgroundGradientEndColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"DFB40D7C-35C3-43FD-84E5-723B9056070F-233-000044404EC63C33","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"TextShadowColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"DFB40D7C-35C3-43FD-84E5-723B9056070F-233-000044404EC63C33","startTime":0}],"identifier":"DFB40D7C-35C3-43FD-84E5-723B9056070F-233-000044404EC63C33_hover","name":"DFB40D7C-35C3-43FD-84E5-723B9056070F-233-000044404EC63C33_hover","duration":1},"CEF7CC60-5176-45D0-A6D2-C7A8511B71F0-233-000044404DDF5767_hover":{"framesPerSecond":30,"animations":[{"startValue":"0px","isRelative":true,"endValue":"0px","identifier":"TextShadowBlurRadius","duration":1,"timingFunction":"easeinout","type":0,"oid":"CEF7CC60-5176-45D0-A6D2-C7A8511B71F0-233-000044404DDF5767","startTime":0},{"startValue":"#E6E6E6","isRelative":true,"endValue":"#EFEFEF","identifier":"BackgroundGradientStartColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"CEF7CC60-5176-45D0-A6D2-C7A8511B71F0-233-000044404DDF5767","startTime":0},{"startValue":"#000000","isRelative":true,"endValue":"#000000","identifier":"TextColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"CEF7CC60-5176-45D0-A6D2-C7A8511B71F0-233-000044404DDF5767","startTime":0},{"startValue":"1px","isRelative":true,"endValue":"2px","identifier":"TextShadowYOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"CEF7CC60-5176-45D0-A6D2-C7A8511B71F0-233-000044404DDF5767","startTime":0},{"startValue":"0px","isRelative":true,"endValue":"1px","identifier":"TextShadowXOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"CEF7CC60-5176-45D0-A6D2-C7A8511B71F0-233-000044404DDF5767","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"BackgroundGradientEndColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"CEF7CC60-5176-45D0-A6D2-C7A8511B71F0-233-000044404DDF5767","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"TextShadowColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"CEF7CC60-5176-45D0-A6D2-C7A8511B71F0-233-000044404DDF5767","startTime":0}],"identifier":"CEF7CC60-5176-45D0-A6D2-C7A8511B71F0-233-000044404DDF5767_hover","name":"CEF7CC60-5176-45D0-A6D2-C7A8511B71F0-233-000044404DDF5767_hover","duration":1},"84B7581F-5446-47FF-A6E7-AC2A612015A4-233-000044404F101711_hover":{"framesPerSecond":30,"animations":[{"startValue":"0px","isRelative":true,"endValue":"0px","identifier":"TextShadowBlurRadius","duration":1,"timingFunction":"easeinout","type":0,"oid":"84B7581F-5446-47FF-A6E7-AC2A612015A4-233-000044404F101711","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"BackgroundGradientStartColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"84B7581F-5446-47FF-A6E7-AC2A612015A4-233-000044404F101711","startTime":0},{"startValue":"#333333","isRelative":true,"endValue":"#3C86D3","identifier":"TextColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"84B7581F-5446-47FF-A6E7-AC2A612015A4-233-000044404F101711","startTime":0},{"startValue":"1px","isRelative":true,"endValue":"2px","identifier":"TextShadowYOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"84B7581F-5446-47FF-A6E7-AC2A612015A4-233-000044404F101711","startTime":0},{"startValue":"0px","isRelative":true,"endValue":"1px","identifier":"TextShadowXOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"84B7581F-5446-47FF-A6E7-AC2A612015A4-233-000044404F101711","startTime":0},{"startValue":"#E6E6E6","isRelative":true,"endValue":"#EFEFEF","identifier":"BackgroundGradientEndColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"84B7581F-5446-47FF-A6E7-AC2A612015A4-233-000044404F101711","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"TextShadowColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"84B7581F-5446-47FF-A6E7-AC2A612015A4-233-000044404F101711","startTime":0}],"identifier":"84B7581F-5446-47FF-A6E7-AC2A612015A4-233-000044404F101711_hover","name":"84B7581F-5446-47FF-A6E7-AC2A612015A4-233-000044404F101711_hover","duration":1},"kTimelineDefaultIdentifier":{"framesPerSecond":30,"animations":[],"identifier":"kTimelineDefaultIdentifier","name":"Main Timeline","duration":0},"BC65D01F-D98B-4E11-BDB8-FDCC98FCB210-233-000044404E867CCE_hover":{"framesPerSecond":30,"animations":[{"startValue":"0px","isRelative":true,"endValue":"0px","identifier":"TextShadowBlurRadius","duration":1,"timingFunction":"easeinout","type":0,"oid":"BC65D01F-D98B-4E11-BDB8-FDCC98FCB210-233-000044404E867CCE","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"BackgroundGradientStartColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"BC65D01F-D98B-4E11-BDB8-FDCC98FCB210-233-000044404E867CCE","startTime":0},{"startValue":"#333333","isRelative":true,"endValue":"#3C86D3","identifier":"TextColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"BC65D01F-D98B-4E11-BDB8-FDCC98FCB210-233-000044404E867CCE","startTime":0},{"startValue":"1px","isRelative":true,"endValue":"2px","identifier":"TextShadowYOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"BC65D01F-D98B-4E11-BDB8-FDCC98FCB210-233-000044404E867CCE","startTime":0},{"startValue":"0px","isRelative":true,"endValue":"1px","identifier":"TextShadowXOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"BC65D01F-D98B-4E11-BDB8-FDCC98FCB210-233-000044404E867CCE","startTime":0},{"startValue":"#E6E6E6","isRelative":true,"endValue":"#EFEFEF","identifier":"BackgroundGradientEndColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"BC65D01F-D98B-4E11-BDB8-FDCC98FCB210-233-000044404E867CCE","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"TextShadowColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"BC65D01F-D98B-4E11-BDB8-FDCC98FCB210-233-000044404E867CCE","startTime":0}],"identifier":"BC65D01F-D98B-4E11-BDB8-FDCC98FCB210-233-000044404E867CCE_hover","name":"BC65D01F-D98B-4E11-BDB8-FDCC98FCB210-233-000044404E867CCE_hover","duration":1},"9693AB99-4B88-41FB-B384-E24A43B82DC3-233-000044404E313453_hover":{"framesPerSecond":30,"animations":[{"startValue":"0px","isRelative":true,"endValue":"0px","identifier":"TextShadowBlurRadius","duration":1,"timingFunction":"easeinout","type":0,"oid":"9693AB99-4B88-41FB-B384-E24A43B82DC3-233-000044404E313453","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"BackgroundGradientStartColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"9693AB99-4B88-41FB-B384-E24A43B82DC3-233-000044404E313453","startTime":0},{"startValue":"#333333","isRelative":true,"endValue":"#3C86D3","identifier":"TextColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"9693AB99-4B88-41FB-B384-E24A43B82DC3-233-000044404E313453","startTime":0},{"startValue":"1px","isRelative":true,"endValue":"2px","identifier":"TextShadowYOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"9693AB99-4B88-41FB-B384-E24A43B82DC3-233-000044404E313453","startTime":0},{"startValue":"0px","isRelative":true,"endValue":"1px","identifier":"TextShadowXOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"9693AB99-4B88-41FB-B384-E24A43B82DC3-233-000044404E313453","startTime":0},{"startValue":"#E6E6E6","isRelative":true,"endValue":"#EFEFEF","identifier":"BackgroundGradientEndColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"9693AB99-4B88-41FB-B384-E24A43B82DC3-233-000044404E313453","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"TextShadowColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"9693AB99-4B88-41FB-B384-E24A43B82DC3-233-000044404E313453","startTime":0}],"identifier":"9693AB99-4B88-41FB-B384-E24A43B82DC3-233-000044404E313453_hover","name":"9693AB99-4B88-41FB-B384-E24A43B82DC3-233-000044404E313453_hover","duration":1}},"id":"62A7DFA9-2B38-49E6-9694-0E4FE9F8B2E8-233-000044404F9F937D","sceneIndex":1,"perspective":"600px","oid":"62A7DFA9-2B38-49E6-9694-0E4FE9F8B2E8-233-000044404F9F937D","initialValues":{"36F27B05-6F29-4D64-9534-9078E6EB1635-23929-0001019DEF9A4101":{"Position":"absolute","BackgroundOrigin":"content-box","Left":"391px","Display":"inline","BackgroundImage":"library.png","Height":"475px","Overflow":"visible","BackgroundSize":"100% 100%","ZIndex":"14","Top":"53px","Width":"499px","TagName":"div"},"F2FA65E5-39DA-465C-822B-5388DD6471BF-233-000044404DCCEE0B":{"FontFamily":"Helvetica,Arial,Sans-Serif","FontWeight":"normal","TagName":"div","PaddingRight":"8px","FontSize":"48px","LetterSpacing":"-2px","Display":"inline","WordWrap":"break-word","PaddingBottom":"8px","Top":"112px","UserSelect":"none","WhiteSpaceCollapsing":"preserve","Position":"absolute","Height":"46px","Left":"72px","InnerHTML":"Build Your Web<div>App Library</div>","ZIndex":"12","PaddingLeft":"8px","Width":"339px","PaddingTop":"8px","Overflow":"visible","TextColor":"#000000"},"9693AB99-4B88-41FB-B384-E24A43B82DC3-233-000044404E313453":{"ActionOnMouseClick":{"type":1,"transition":1,"sceneOid":"63312270-7D17-479F-A107-D656370C794D-73864-00015045950F244D"},"BorderStyleTop":"Solid","BackgroundColor":"#F0F0F0","WordWrap":"break-word","FontWeight":"normal","Display":"inline","BorderStyleRight":"Solid","BorderWidthBottom":"1px","BorderWidthRight":"1px","BorderWidthTop":"1px","ButtonHover":"9693AB99-4B88-41FB-B384-E24A43B82DC3-233-000044404E313453_hover","BorderStyleLeft":"Solid","BorderColorBottom":"#B3B3B3","FontSize":"14px","TextColor":"#333333","InnerHTML":"Welcome to<div>Raven for Mac</div>","Height":"36px","TextAlign":"left","ZIndex":"7","PaddingLeft":"14px","Top":"528px","BackgroundGradientStartColor":"#FFFFFF","UserSelect":"none","WhiteSpaceCollapsing":"preserve","TextShadowXOffset":"0px","BorderColorTop":"#B3B3B3","PaddingTop":"14px","TagName":"div","BorderStyleBottom":"Solid","BackgroundGradientAngle":"0deg","PaddingBottom":"14px","FontFamily":"'Helvetica Neue',Arial,Helvetica,Sans-Serif","PaddingRight":"14px","Position":"absolute","TextShadowColor":"#FFFFFF","Width":"130px","BorderColorLeft":"#B3B3B3","BorderRadiusBottomRight":"0px","Left":"31px","BorderColorRight":"#B3B3B3","BorderRadiusBottomLeft":"10px","BorderWidthLeft":"1px","TextShadowBlurRadius":"0px","TextShadowYOffset":"1px","Cursor":"pointer","BackgroundGradientEndColor":"#E6E6E6","Overflow":"visible","LetterSpacing":"0px"},"4890225B-67C7-4C0C-802C-12049BA98C49-23929-0001021257E5AF1D":{"Position":"absolute","BackgroundOrigin":"content-box","Left":"391px","Display":"inline","BackgroundImage":"small.png","Height":"16px","Overflow":"visible","BackgroundSize":"100% 100%","ZIndex":"15","Top":"351px","Width":"16px","Opacity":"0.325448","TagName":"div"},"CA02F625-AB03-45B0-8CD8-98C85BF5856D-233-000044404F8F9D3D":{"BorderWidthLeft":"1px","TagName":"div","BorderColorBottom":"#A0A0A0","BorderStyleRight":"Solid","BorderStyleBottom":"Solid","BoxShadowBlurRadius":"5px","Top":"23px","BorderStyleLeft":"Solid","BorderWidthRight":"1px","BorderColorTop":"#A0A0A0","BorderColorLeft":"#A0A0A0","BoxShadowYOffset":"0px","UserSelect":"none","Position":"absolute","Height":"569px","Left":"31px","BoxShadowColor":"#959595","BorderColorRight":"#A0A0A0","BorderStyleTop":"Solid","BorderRadiusTopLeft":"10px","ZIndex":"1","Width":"858px","BorderWidthTop":"1px","BoxShadowXOffset":"0px","BorderRadiusBottomLeft":"10px","BorderRadiusTopRight":"10px","Overflow":"visible","BorderRadiusBottomRight":"10px","BorderWidthBottom":"1px","BackgroundColor":"#FFFFFF"},"CEF7CC60-5176-45D0-A6D2-C7A8511B71F0-233-000044404DDF5767":{"BorderStyleTop":"Solid","BorderStyleRight":"Solid","BackgroundColor":"#F0F0F0","WordWrap":"break-word","FontWeight":"normal","Display":"inline","BorderWidthBottom":"1px","BorderWidthRight":"1px","BorderWidthTop":"1px","ButtonHover":"CEF7CC60-5176-45D0-A6D2-C7A8511B71F0-233-000044404DDF5767_hover","BorderStyleLeft":"Solid","BorderColorBottom":"#B3B3B3","FontSize":"14px","TextColor":"#000000","InnerHTML":"Build Your Web<div>App&nbsp;Library</div>","Height":"36px","TextAlign":"left","ZIndex":"6","PaddingLeft":"14px","Top":"528px","BackgroundGradientStartColor":"#E6E6E6","UserSelect":"none","WhiteSpaceCollapsing":"preserve","TextShadowXOffset":"0px","BorderColorTop":"#B3B3B3","PaddingTop":"14px","TagName":"div","BorderStyleBottom":"Solid","BackgroundGradientAngle":"0deg","PaddingBottom":"14px","FontFamily":"'Helvetica Neue',Arial,Helvetica,Sans-Serif","PaddingRight":"14px","Position":"absolute","TextShadowColor":"#FFFFFF","Width":"139px","BorderColorLeft":"#B3B3B3","BorderRadiusBottomRight":"0px","Left":"187px","BorderColorRight":"#B3B3B3","BorderRadiusBottomLeft":"0px","BorderWidthLeft":"1px","TextShadowBlurRadius":"0px","TextShadowYOffset":"1px","Cursor":"pointer","BackgroundGradientEndColor":"#FFFFFF","Overflow":"visible","LetterSpacing":"0px"},"DFB40D7C-35C3-43FD-84E5-723B9056070F-233-000044404EC63C33":{"ActionOnMouseClick":{"type":1,"transition":1,"sceneOid":"D31FB37E-5520-48E5-A0C3-6F9BA7834791-233-00004BCF153486D2"},"BorderStyleTop":"Solid","BackgroundColor":"#F0F0F0","WordWrap":"break-word","FontWeight":"normal","Display":"inline","BorderStyleRight":"Solid","BorderWidthBottom":"1px","BorderWidthRight":"1px","BorderWidthTop":"1px","ButtonHover":"DFB40D7C-35C3-43FD-84E5-723B9056070F-233-000044404EC63C33_hover","BorderStyleLeft":"Solid","BorderColorBottom":"#B3B3B3","FontSize":"14px","TextColor":"#333333","InnerHTML":"Visting the<div>Web App Shop</div>","Height":"36px","TextAlign":"left","ZIndex":"9","PaddingLeft":"14px","Top":"528px","BackgroundGradientStartColor":"#FFFFFF","UserSelect":"none","WhiteSpaceCollapsing":"preserve","TextShadowXOffset":"0px","BorderColorTop":"#B3B3B3","PaddingTop":"14px","TagName":"div","BorderStyleBottom":"Solid","BackgroundGradientAngle":"0deg","PaddingBottom":"14px","FontFamily":"'Helvetica Neue',Arial,Helvetica,Sans-Serif","PaddingRight":"14px","Position":"absolute","TextShadowColor":"#FFFFFF","Width":"160px","BorderColorLeft":"#B3B3B3","BorderRadiusBottomRight":"10px","Left":"701px","BorderColorRight":"#B3B3B3","BorderRadiusBottomLeft":"0px","BorderWidthLeft":"1px","TextShadowBlurRadius":"0px","TextShadowYOffset":"1px","Cursor":"pointer","BackgroundGradientEndColor":"#E6E6E6","Overflow":"visible","LetterSpacing":"0px"},"C49A013D-4EA2-458D-A749-27A3F6D788B2-233-000044404E735562":{"FontFamily":"'Helvetica Neue',Arial,Helvetica,Sans-Serif","TagName":"div","PaddingRight":"8px","FontSize":"17px","Display":"inline","WordWrap":"break-word","PaddingBottom":"8px","Top":"241px","UserSelect":"none","WhiteSpaceCollapsing":"preserve","Position":"absolute","Height":"219px","Left":"72px","InnerHTML":"We've redesigned the way you manage your library of web apps so that they are easier to access and collect.<div><br></div><div>Once you install your favorite web apps from the Web App Shop click the library button in the lower left hand corner of your browser window.</div><div><br></div><div>You can click on any web app to instantly add it to your Smart Bar. Drag and drop them out of the Smart Bar to remove.</div>","ZIndex":"13","Width":"332px","PaddingLeft":"8px","PaddingTop":"8px","Overflow":"visible","TextColor":"#666666"},"84B7581F-5446-47FF-A6E7-AC2A612015A4-233-000044404F101711":{"ActionOnMouseClick":{"type":1,"transition":1,"sceneOid":"1952F16F-11C6-44E6-8C53-F6B4588C2F70-233-0000473500C5B081"},"BorderStyleTop":"Solid","BackgroundColor":"#F0F0F0","WordWrap":"break-word","FontWeight":"normal","Display":"inline","BorderStyleRight":"Solid","BorderWidthBottom":"1px","BorderWidthRight":"1px","BorderWidthTop":"1px","ButtonHover":"84B7581F-5446-47FF-A6E7-AC2A612015A4-233-000044404F101711_hover","BorderStyleLeft":"Solid","BorderColorBottom":"#B3B3B3","FontSize":"14px","TextColor":"#333333","InnerHTML":"<span class=\"Apple-style-span\" style=\"color: rgb(0, 0, 0); \">Browsing your<div style=\"-webkit-transform: rotateY(0deg); \">Bookmarks</div></span>","Height":"36px","TextAlign":"left","ZIndex":"10","PaddingLeft":"14px","Top":"528px","BackgroundGradientStartColor":"#FFFFFF","UserSelect":"none","WhiteSpaceCollapsing":"preserve","TextShadowXOffset":"0px","BorderColorTop":"#B3B3B3","PaddingTop":"14px","TagName":"div","BorderStyleBottom":"Solid","BackgroundGradientAngle":"0deg","PaddingBottom":"14px","FontFamily":"'Helvetica Neue',Arial,Helvetica,Sans-Serif","PaddingRight":"14px","Position":"absolute","TextShadowColor":"#FFFFFF","Width":"146px","BorderColorLeft":"#B3B3B3","BorderRadiusBottomRight":"0px","Left":"526px","BorderColorRight":"#B3B3B3","BorderRadiusBottomLeft":"0px","BorderWidthLeft":"1px","TextShadowBlurRadius":"0px","TextShadowYOffset":"1px","Cursor":"pointer","BackgroundGradientEndColor":"#E6E6E6","Overflow":"visible","LetterSpacing":"0px"},"BC65D01F-D98B-4E11-BDB8-FDCC98FCB210-233-000044404E867CCE":{"ActionOnMouseClick":{"type":1,"transition":1,"sceneOid":"E5C5FC9B-874F-4B52-8BAA-0CE133341F42-233-000049C968DF1C30"},"BorderStyleTop":"Solid","BackgroundColor":"#F0F0F0","WordWrap":"break-word","FontWeight":"normal","Display":"inline","BorderStyleRight":"Solid","BorderWidthBottom":"1px","BorderWidthRight":"1px","BorderWidthTop":"1px","ButtonHover":"BC65D01F-D98B-4E11-BDB8-FDCC98FCB210-233-000044404E867CCE_hover","BorderStyleLeft":"Solid","BorderColorBottom":"#B3B3B3","FontSize":"14px","TextColor":"#333333","InnerHTML":"Adding Favorites<div>&amp; Bookmarks</div>","Height":"36px","TextAlign":"left","ZIndex":"8","PaddingLeft":"14px","Top":"528px","BackgroundGradientStartColor":"#FFFFFF","UserSelect":"none","WhiteSpaceCollapsing":"preserve","TextShadowXOffset":"0px","BorderColorTop":"#B3B3B3","PaddingTop":"14px","TagName":"div","BorderStyleBottom":"Solid","BackgroundGradientAngle":"0deg","PaddingBottom":"14px","FontFamily":"'Helvetica Neue',Arial,Helvetica,Sans-Serif","PaddingRight":"14px","Position":"absolute","TextShadowColor":"#FFFFFF","Width":"151px","BorderColorLeft":"#B3B3B3","BorderRadiusBottomRight":"0px","Left":"350px","BorderColorRight":"#B3B3B3","BorderRadiusBottomLeft":"0px","BorderWidthLeft":"1px","TextShadowBlurRadius":"0px","TextShadowYOffset":"1px","Cursor":"pointer","BackgroundGradientEndColor":"#E6E6E6","Overflow":"visible","LetterSpacing":"0px"}},"name":"Library","backgroundColor":"#E2E4E2"},{"timelines":{"AA09E563-41D4-4736-B3AD-D90C7E8CE2D2-233-000049C967BDB09A_hover":{"framesPerSecond":30,"animations":[{"startValue":"0px","isRelative":true,"endValue":"0px","identifier":"TextShadowBlurRadius","duration":1,"timingFunction":"easeinout","type":0,"oid":"AA09E563-41D4-4736-B3AD-D90C7E8CE2D2-233-000049C967BDB09A","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"BackgroundGradientStartColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"AA09E563-41D4-4736-B3AD-D90C7E8CE2D2-233-000049C967BDB09A","startTime":0},{"startValue":"#333333","isRelative":true,"endValue":"#3C86D3","identifier":"TextColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"AA09E563-41D4-4736-B3AD-D90C7E8CE2D2-233-000049C967BDB09A","startTime":0},{"startValue":"1px","isRelative":true,"endValue":"2px","identifier":"TextShadowYOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"AA09E563-41D4-4736-B3AD-D90C7E8CE2D2-233-000049C967BDB09A","startTime":0},{"startValue":"0px","isRelative":true,"endValue":"1px","identifier":"TextShadowXOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"AA09E563-41D4-4736-B3AD-D90C7E8CE2D2-233-000049C967BDB09A","startTime":0},{"startValue":"#E6E6E6","isRelative":true,"endValue":"#EFEFEF","identifier":"BackgroundGradientEndColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"AA09E563-41D4-4736-B3AD-D90C7E8CE2D2-233-000049C967BDB09A","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"TextShadowColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"AA09E563-41D4-4736-B3AD-D90C7E8CE2D2-233-000049C967BDB09A","startTime":0}],"identifier":"AA09E563-41D4-4736-B3AD-D90C7E8CE2D2-233-000049C967BDB09A_hover","name":"AA09E563-41D4-4736-B3AD-D90C7E8CE2D2-233-000049C967BDB09A_hover","duration":1},"AAFE96F8-33B7-4B42-B115-24FDCC98D434-233-000049C968A16E68_hover":{"framesPerSecond":30,"animations":[{"startValue":"0px","isRelative":true,"endValue":"0px","identifier":"TextShadowBlurRadius","duration":1,"timingFunction":"easeinout","type":0,"oid":"AAFE96F8-33B7-4B42-B115-24FDCC98D434-233-000049C968A16E68","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"BackgroundGradientStartColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"AAFE96F8-33B7-4B42-B115-24FDCC98D434-233-000049C968A16E68","startTime":0},{"startValue":"#333333","isRelative":true,"endValue":"#3C86D3","identifier":"TextColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"AAFE96F8-33B7-4B42-B115-24FDCC98D434-233-000049C968A16E68","startTime":0},{"startValue":"1px","isRelative":true,"endValue":"2px","identifier":"TextShadowYOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"AAFE96F8-33B7-4B42-B115-24FDCC98D434-233-000049C968A16E68","startTime":0},{"startValue":"0px","isRelative":true,"endValue":"1px","identifier":"TextShadowXOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"AAFE96F8-33B7-4B42-B115-24FDCC98D434-233-000049C968A16E68","startTime":0},{"startValue":"#E6E6E6","isRelative":true,"endValue":"#EFEFEF","identifier":"BackgroundGradientEndColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"AAFE96F8-33B7-4B42-B115-24FDCC98D434-233-000049C968A16E68","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"TextShadowColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"AAFE96F8-33B7-4B42-B115-24FDCC98D434-233-000049C968A16E68","startTime":0}],"identifier":"AAFE96F8-33B7-4B42-B115-24FDCC98D434-233-000049C968A16E68_hover","name":"AAFE96F8-33B7-4B42-B115-24FDCC98D434-233-000049C968A16E68_hover","duration":1},"5932BDDC-D41F-400C-9259-35958F4715DC-233-000049C9675003F5_hover":{"framesPerSecond":30,"animations":[{"startValue":"0px","isRelative":true,"endValue":"0px","identifier":"TextShadowBlurRadius","duration":1,"timingFunction":"easeinout","type":0,"oid":"5932BDDC-D41F-400C-9259-35958F4715DC-233-000049C9675003F5","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"BackgroundGradientStartColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"5932BDDC-D41F-400C-9259-35958F4715DC-233-000049C9675003F5","startTime":0},{"startValue":"#333333","isRelative":true,"endValue":"#3C86D3","identifier":"TextColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"5932BDDC-D41F-400C-9259-35958F4715DC-233-000049C9675003F5","startTime":0},{"startValue":"1px","isRelative":true,"endValue":"2px","identifier":"TextShadowYOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"5932BDDC-D41F-400C-9259-35958F4715DC-233-000049C9675003F5","startTime":0},{"startValue":"0px","isRelative":true,"endValue":"1px","identifier":"TextShadowXOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"5932BDDC-D41F-400C-9259-35958F4715DC-233-000049C9675003F5","startTime":0},{"startValue":"#E6E6E6","isRelative":true,"endValue":"#EFEFEF","identifier":"BackgroundGradientEndColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"5932BDDC-D41F-400C-9259-35958F4715DC-233-000049C9675003F5","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"TextShadowColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"5932BDDC-D41F-400C-9259-35958F4715DC-233-000049C9675003F5","startTime":0}],"identifier":"5932BDDC-D41F-400C-9259-35958F4715DC-233-000049C9675003F5_hover","name":"5932BDDC-D41F-400C-9259-35958F4715DC-233-000049C9675003F5_hover","duration":1},"07896FA2-B8F7-4AD2-98B7-5615298ADBBB-233-000049C968598DD3_hover":{"framesPerSecond":30,"animations":[{"startValue":"0px","isRelative":true,"endValue":"0px","identifier":"TextShadowBlurRadius","duration":1,"timingFunction":"easeinout","type":0,"oid":"07896FA2-B8F7-4AD2-98B7-5615298ADBBB-233-000049C968598DD3","startTime":0},{"startValue":"#E6E6E6","isRelative":true,"endValue":"#EFEFEF","identifier":"BackgroundGradientStartColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"07896FA2-B8F7-4AD2-98B7-5615298ADBBB-233-000049C968598DD3","startTime":0},{"startValue":"#000000","isRelative":true,"endValue":"#000000","identifier":"TextColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"07896FA2-B8F7-4AD2-98B7-5615298ADBBB-233-000049C968598DD3","startTime":0},{"startValue":"1px","isRelative":true,"endValue":"2px","identifier":"TextShadowYOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"07896FA2-B8F7-4AD2-98B7-5615298ADBBB-233-000049C968598DD3","startTime":0},{"startValue":"0px","isRelative":true,"endValue":"1px","identifier":"TextShadowXOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"07896FA2-B8F7-4AD2-98B7-5615298ADBBB-233-000049C968598DD3","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"BackgroundGradientEndColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"07896FA2-B8F7-4AD2-98B7-5615298ADBBB-233-000049C968598DD3","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"TextShadowColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"07896FA2-B8F7-4AD2-98B7-5615298ADBBB-233-000049C968598DD3","startTime":0}],"identifier":"07896FA2-B8F7-4AD2-98B7-5615298ADBBB-233-000049C968598DD3_hover","name":"07896FA2-B8F7-4AD2-98B7-5615298ADBBB-233-000049C968598DD3_hover","duration":1},"FA1A0875-BF85-4E61-8669-860CD05A9DCD-233-000049C96806D5DC_hover":{"framesPerSecond":30,"animations":[{"startValue":"0px","isRelative":true,"endValue":"0px","identifier":"TextShadowBlurRadius","duration":1,"timingFunction":"easeinout","type":0,"oid":"FA1A0875-BF85-4E61-8669-860CD05A9DCD-233-000049C96806D5DC","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"BackgroundGradientStartColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"FA1A0875-BF85-4E61-8669-860CD05A9DCD-233-000049C96806D5DC","startTime":0},{"startValue":"#333333","isRelative":true,"endValue":"#3C86D3","identifier":"TextColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"FA1A0875-BF85-4E61-8669-860CD05A9DCD-233-000049C96806D5DC","startTime":0},{"startValue":"1px","isRelative":true,"endValue":"2px","identifier":"TextShadowYOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"FA1A0875-BF85-4E61-8669-860CD05A9DCD-233-000049C96806D5DC","startTime":0},{"startValue":"0px","isRelative":true,"endValue":"1px","identifier":"TextShadowXOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"FA1A0875-BF85-4E61-8669-860CD05A9DCD-233-000049C96806D5DC","startTime":0},{"startValue":"#E6E6E6","isRelative":true,"endValue":"#EFEFEF","identifier":"BackgroundGradientEndColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"FA1A0875-BF85-4E61-8669-860CD05A9DCD-233-000049C96806D5DC","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"TextShadowColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"FA1A0875-BF85-4E61-8669-860CD05A9DCD-233-000049C96806D5DC","startTime":0}],"identifier":"FA1A0875-BF85-4E61-8669-860CD05A9DCD-233-000049C96806D5DC_hover","name":"FA1A0875-BF85-4E61-8669-860CD05A9DCD-233-000049C96806D5DC_hover","duration":1},"kTimelineDefaultIdentifier":{"framesPerSecond":30,"animations":[],"identifier":"kTimelineDefaultIdentifier","name":"Main Timeline","duration":0}},"id":"E5C5FC9B-874F-4B52-8BAA-0CE133341F42-233-000049C968DF1C30","sceneIndex":2,"perspective":"600px","oid":"E5C5FC9B-874F-4B52-8BAA-0CE133341F42-233-000049C968DF1C30","initialValues":{"E273BC34-57F4-4FF9-B5F3-983CB55ED877-233-000049C967AE5AB9":{"FontFamily":"Helvetica,Arial,Sans-Serif","FontWeight":"normal","TagName":"div","PaddingRight":"8px","FontSize":"48px","LetterSpacing":"-2px","Display":"inline","WordWrap":"break-word","PaddingBottom":"8px","Top":"112px","UserSelect":"none","WhiteSpaceCollapsing":"preserve","Position":"absolute","Height":"46px","Left":"72px","InnerHTML":"Adding Favorites<div>&amp; Bookmarks</div>","ZIndex":"12","PaddingLeft":"8px","Width":"339px","PaddingTop":"8px","Overflow":"visible","TextColor":"#000000"},"5932BDDC-D41F-400C-9259-35958F4715DC-233-000049C9675003F5":{"ActionOnMouseClick":{"type":1,"transition":1,"sceneOid":"63312270-7D17-479F-A107-D656370C794D-73864-00015045950F244D"},"BorderStyleTop":"Solid","BackgroundColor":"#F0F0F0","WordWrap":"break-word","FontWeight":"normal","Display":"inline","BorderStyleRight":"Solid","BorderWidthBottom":"1px","BorderWidthRight":"1px","BorderWidthTop":"1px","ButtonHover":"5932BDDC-D41F-400C-9259-35958F4715DC-233-000049C9675003F5_hover","BorderStyleLeft":"Solid","BorderColorBottom":"#B3B3B3","FontSize":"14px","TextColor":"#333333","InnerHTML":"Welcome to<div>Raven for Mac</div>","Height":"36px","TextAlign":"left","ZIndex":"7","PaddingLeft":"14px","Top":"528px","BackgroundGradientStartColor":"#FFFFFF","UserSelect":"none","WhiteSpaceCollapsing":"preserve","TextShadowXOffset":"0px","BorderColorTop":"#B3B3B3","PaddingTop":"14px","TagName":"div","BorderStyleBottom":"Solid","BackgroundGradientAngle":"0deg","PaddingBottom":"14px","FontFamily":"'Helvetica Neue',Arial,Helvetica,Sans-Serif","PaddingRight":"14px","Position":"absolute","TextShadowColor":"#FFFFFF","Width":"130px","BorderColorLeft":"#B3B3B3","BorderRadiusBottomRight":"0px","Left":"31px","BorderColorRight":"#B3B3B3","BorderRadiusBottomLeft":"10px","BorderWidthLeft":"1px","TextShadowBlurRadius":"0px","TextShadowYOffset":"1px","Cursor":"pointer","BackgroundGradientEndColor":"#E6E6E6","Overflow":"visible","LetterSpacing":"0px"},"9B8D8E13-56F9-428B-8889-3834D9F4825C-233-000049C9674522F3":{"Position":"absolute","BackgroundOrigin":"content-box","Display":"inline","Left":"432px","BackgroundImage":"favorite-2.png","Height":"476px","Overflow":"visible","Width":"459px","ZIndex":"14","BackgroundSize":"100% 100%","Top":"52px","BackgroundRepeat":"no-repeat","TagName":"div"},"AA09E563-41D4-4736-B3AD-D90C7E8CE2D2-233-000049C967BDB09A":{"ActionOnMouseClick":{"type":1,"transition":1,"sceneOid":"62A7DFA9-2B38-49E6-9694-0E4FE9F8B2E8-233-000044404F9F937D"},"BorderStyleTop":"Solid","BackgroundColor":"#F0F0F0","WordWrap":"break-word","FontWeight":"normal","Display":"inline","BorderStyleRight":"Solid","BorderWidthBottom":"1px","BorderWidthRight":"1px","BorderWidthTop":"1px","ButtonHover":"AA09E563-41D4-4736-B3AD-D90C7E8CE2D2-233-000049C967BDB09A_hover","BorderStyleLeft":"Solid","BorderColorBottom":"#B3B3B3","FontSize":"14px","TextColor":"#333333","InnerHTML":"<div style=\"-webkit-transform: rotateY(0deg); \">Build Your Web</div><div style=\"-webkit-transform: rotateY(0deg); \">App Library</div>","Height":"36px","TextAlign":"left","ZIndex":"8","PaddingLeft":"14px","Top":"528px","BackgroundGradientStartColor":"#FFFFFF","UserSelect":"none","WhiteSpaceCollapsing":"preserve","TextShadowXOffset":"0px","BorderColorTop":"#B3B3B3","PaddingTop":"14px","TagName":"div","BorderStyleBottom":"Solid","BackgroundGradientAngle":"0deg","PaddingBottom":"14px","FontFamily":"'Helvetica Neue',Arial,Helvetica,Sans-Serif","PaddingRight":"14px","Position":"absolute","TextShadowColor":"#FFFFFF","Width":"136px","BorderColorLeft":"#B3B3B3","BorderRadiusBottomRight":"0px","Left":"186px","BorderColorRight":"#B3B3B3","BorderRadiusBottomLeft":"0px","BorderWidthLeft":"1px","TextShadowBlurRadius":"0px","TextShadowYOffset":"1px","Cursor":"pointer","BackgroundGradientEndColor":"#E6E6E6","Overflow":"visible","LetterSpacing":"0px"},"1EA9D7B9-6CFE-4ABC-860A-65204C952FFF-233-000049C96896DE87":{"FontFamily":"'Helvetica Neue',Arial,Helvetica,Sans-Serif","TagName":"div","PaddingRight":"8px","FontSize":"17px","Display":"inline","WordWrap":"break-word","PaddingBottom":"8px","Top":"241px","UserSelect":"none","WhiteSpaceCollapsing":"preserve","Position":"absolute","Height":"219px","Left":"72px","InnerHTML":"Adding a new website or bookmark to Raven is simple. Click the + icon located in the menu items in the upper right.&nbsp;<div><br></div><div>You'll see a sheet that will help you choose whether you want to save a favorite or a bookmark. You can even send it to Instapaper.</div><div><br></div><div>Favorites are sites you visit everyday. Bookmarks are for reference like an article you want to read later.</div>","ZIndex":"13","Width":"332px","PaddingLeft":"8px","PaddingTop":"8px","Overflow":"visible","TextColor":"#666666"},"07896FA2-B8F7-4AD2-98B7-5615298ADBBB-233-000049C968598DD3":{"BorderStyleTop":"Solid","BorderStyleRight":"Solid","BackgroundColor":"#F0F0F0","WordWrap":"break-word","FontWeight":"normal","Display":"inline","BorderWidthBottom":"1px","BorderWidthRight":"1px","BorderWidthTop":"1px","ButtonHover":"07896FA2-B8F7-4AD2-98B7-5615298ADBBB-233-000049C968598DD3_hover","BorderStyleLeft":"Solid","BorderColorBottom":"#B3B3B3","FontSize":"14px","TextColor":"#000000","InnerHTML":"Adding Favorites<div>&amp; Bookmarks</div>","Height":"36px","TextAlign":"left","ZIndex":"6","PaddingLeft":"14px","Top":"528px","BackgroundGradientStartColor":"#E6E6E6","UserSelect":"none","WhiteSpaceCollapsing":"preserve","TextShadowXOffset":"0px","BorderColorTop":"#B3B3B3","PaddingTop":"14px","TagName":"div","BorderStyleBottom":"Solid","BackgroundGradientAngle":"0deg","PaddingBottom":"14px","FontFamily":"'Helvetica Neue',Arial,Helvetica,Sans-Serif","PaddingRight":"14px","Position":"absolute","TextShadowColor":"#FFFFFF","Width":"146px","BorderColorLeft":"#B3B3B3","BorderRadiusBottomRight":"0px","Left":"351px","BorderColorRight":"#B3B3B3","BorderRadiusBottomLeft":"0px","BorderWidthLeft":"1px","TextShadowBlurRadius":"0px","TextShadowYOffset":"1px","Cursor":"pointer","BackgroundGradientEndColor":"#FFFFFF","Overflow":"visible","LetterSpacing":"0px"},"A1169FC7-D743-47E2-998A-16B40DAC13ED-233-000049C968492B13":{"BorderWidthLeft":"1px","TagName":"div","BorderColorBottom":"#A0A0A0","BorderStyleRight":"Solid","BorderStyleBottom":"Solid","BoxShadowBlurRadius":"5px","Top":"23px","BorderStyleLeft":"Solid","BorderWidthRight":"1px","BorderColorTop":"#A0A0A0","BorderColorLeft":"#A0A0A0","BoxShadowYOffset":"0px","UserSelect":"none","Position":"absolute","Height":"569px","Left":"31px","BoxShadowColor":"#959595","BorderColorRight":"#A0A0A0","BorderStyleTop":"Solid","BorderRadiusTopLeft":"10px","ZIndex":"1","Width":"858px","BorderWidthTop":"1px","BoxShadowXOffset":"0px","BorderRadiusBottomLeft":"10px","BorderRadiusTopRight":"10px","Overflow":"visible","BorderRadiusBottomRight":"10px","BorderWidthBottom":"1px","BackgroundColor":"#FFFFFF"},"AAFE96F8-33B7-4B42-B115-24FDCC98D434-233-000049C968A16E68":{"ActionOnMouseClick":{"type":1,"transition":1,"sceneOid":"D31FB37E-5520-48E5-A0C3-6F9BA7834791-233-00004BCF153486D2"},"BorderStyleTop":"Solid","BackgroundColor":"#F0F0F0","WordWrap":"break-word","FontWeight":"normal","Display":"inline","BorderStyleRight":"Solid","BorderWidthBottom":"1px","BorderWidthRight":"1px","BorderWidthTop":"1px","ButtonHover":"AAFE96F8-33B7-4B42-B115-24FDCC98D434-233-000049C968A16E68_hover","BorderStyleLeft":"Solid","ActionOnMouseDown":{"type":1,"transition":1,"sceneSymbol":1},"BorderColorBottom":"#B3B3B3","FontSize":"14px","TextColor":"#333333","InnerHTML":"Visting the<div>Web App Shop</div>","Height":"36px","TextAlign":"left","ZIndex":"9","PaddingLeft":"14px","Top":"528px","BackgroundGradientStartColor":"#FFFFFF","UserSelect":"none","WhiteSpaceCollapsing":"preserve","TextShadowXOffset":"0px","BorderColorTop":"#B3B3B3","PaddingTop":"14px","TagName":"div","BorderStyleBottom":"Solid","BackgroundGradientAngle":"0deg","PaddingBottom":"14px","FontFamily":"'Helvetica Neue',Arial,Helvetica,Sans-Serif","PaddingRight":"14px","Position":"absolute","TextShadowColor":"#FFFFFF","Width":"160px","BorderColorLeft":"#B3B3B3","BorderRadiusBottomRight":"10px","Left":"701px","BorderColorRight":"#B3B3B3","BorderRadiusBottomLeft":"0px","BorderWidthLeft":"1px","TextShadowBlurRadius":"0px","TextShadowYOffset":"1px","Cursor":"pointer","BackgroundGradientEndColor":"#E6E6E6","Overflow":"visible","LetterSpacing":"0px"},"FA1A0875-BF85-4E61-8669-860CD05A9DCD-233-000049C96806D5DC":{"ActionOnMouseClick":{"type":1,"transition":1,"sceneOid":"1952F16F-11C6-44E6-8C53-F6B4588C2F70-233-0000473500C5B081"},"BorderStyleTop":"Solid","BackgroundColor":"#F0F0F0","WordWrap":"break-word","FontWeight":"normal","Display":"inline","BorderStyleRight":"Solid","BorderWidthBottom":"1px","BorderWidthRight":"1px","BorderWidthTop":"1px","ButtonHover":"FA1A0875-BF85-4E61-8669-860CD05A9DCD-233-000049C96806D5DC_hover","BorderStyleLeft":"Solid","BorderColorBottom":"#B3B3B3","FontSize":"14px","TextColor":"#333333","InnerHTML":"<span class=\"Apple-style-span\" style=\"color: rgb(0, 0, 0); \">Browsing your<div style=\"-webkit-transform: rotateY(0deg); \">Bookmarks</div></span>","Height":"36px","TextAlign":"left","ZIndex":"10","PaddingLeft":"14px","Top":"528px","BackgroundGradientStartColor":"#FFFFFF","UserSelect":"none","WhiteSpaceCollapsing":"preserve","TextShadowXOffset":"0px","BorderColorTop":"#B3B3B3","PaddingTop":"14px","TagName":"div","BorderStyleBottom":"Solid","BackgroundGradientAngle":"0deg","PaddingBottom":"14px","FontFamily":"'Helvetica Neue',Arial,Helvetica,Sans-Serif","PaddingRight":"14px","Position":"absolute","TextShadowColor":"#FFFFFF","Width":"146px","BorderColorLeft":"#B3B3B3","BorderRadiusBottomRight":"0px","Left":"526px","BorderColorRight":"#B3B3B3","BorderRadiusBottomLeft":"0px","BorderWidthLeft":"1px","TextShadowBlurRadius":"0px","TextShadowYOffset":"1px","Cursor":"pointer","BackgroundGradientEndColor":"#E6E6E6","Overflow":"visible","LetterSpacing":"0px"}},"name":"Favorites","backgroundColor":"#E2E4E2"},{"timelines":{"D1FCC306-C7B1-43AC-8CF2-9EC78716F7DF-233-000049DCA1552888_hover":{"framesPerSecond":30,"animations":[{"startValue":"0px","isRelative":true,"endValue":"0px","identifier":"TextShadowBlurRadius","duration":1,"timingFunction":"easeinout","type":0,"oid":"D1FCC306-C7B1-43AC-8CF2-9EC78716F7DF-233-000049DCA1552888","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"BackgroundGradientStartColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"D1FCC306-C7B1-43AC-8CF2-9EC78716F7DF-233-000049DCA1552888","startTime":0},{"startValue":"#333333","isRelative":true,"endValue":"#3C86D3","identifier":"TextColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"D1FCC306-C7B1-43AC-8CF2-9EC78716F7DF-233-000049DCA1552888","startTime":0},{"startValue":"1px","isRelative":true,"endValue":"2px","identifier":"TextShadowYOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"D1FCC306-C7B1-43AC-8CF2-9EC78716F7DF-233-000049DCA1552888","startTime":0},{"startValue":"0px","isRelative":true,"endValue":"1px","identifier":"TextShadowXOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"D1FCC306-C7B1-43AC-8CF2-9EC78716F7DF-233-000049DCA1552888","startTime":0},{"startValue":"#E6E6E6","isRelative":true,"endValue":"#EFEFEF","identifier":"BackgroundGradientEndColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"D1FCC306-C7B1-43AC-8CF2-9EC78716F7DF-233-000049DCA1552888","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"TextShadowColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"D1FCC306-C7B1-43AC-8CF2-9EC78716F7DF-233-000049DCA1552888","startTime":0}],"identifier":"D1FCC306-C7B1-43AC-8CF2-9EC78716F7DF-233-000049DCA1552888_hover","name":"D1FCC306-C7B1-43AC-8CF2-9EC78716F7DF-233-000049DCA1552888_hover","duration":1},"92E5A5A5-60D2-4964-9A64-6CC554184D87-233-000049D81F1C185C_hover":{"framesPerSecond":30,"animations":[{"startValue":"0px","isRelative":true,"endValue":"0px","identifier":"TextShadowBlurRadius","duration":1,"timingFunction":"easeinout","type":0,"oid":"92E5A5A5-60D2-4964-9A64-6CC554184D87-233-000049D81F1C185C","startTime":0},{"startValue":"#E6E6E6","isRelative":true,"endValue":"#EFEFEF","identifier":"BackgroundGradientStartColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"92E5A5A5-60D2-4964-9A64-6CC554184D87-233-000049D81F1C185C","startTime":0},{"startValue":"#000000","isRelative":true,"endValue":"#000000","identifier":"TextColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"92E5A5A5-60D2-4964-9A64-6CC554184D87-233-000049D81F1C185C","startTime":0},{"startValue":"1px","isRelative":true,"endValue":"2px","identifier":"TextShadowYOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"92E5A5A5-60D2-4964-9A64-6CC554184D87-233-000049D81F1C185C","startTime":0},{"startValue":"0px","isRelative":true,"endValue":"1px","identifier":"TextShadowXOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"92E5A5A5-60D2-4964-9A64-6CC554184D87-233-000049D81F1C185C","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"BackgroundGradientEndColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"92E5A5A5-60D2-4964-9A64-6CC554184D87-233-000049D81F1C185C","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"TextShadowColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"92E5A5A5-60D2-4964-9A64-6CC554184D87-233-000049D81F1C185C","startTime":0}],"identifier":"92E5A5A5-60D2-4964-9A64-6CC554184D87-233-000049D81F1C185C_hover","name":"92E5A5A5-60D2-4964-9A64-6CC554184D87-233-000049D81F1C185C_hover","duration":1},"kTimelineDefaultIdentifier":{"framesPerSecond":30,"animations":[],"identifier":"kTimelineDefaultIdentifier","name":"Main Timeline","duration":0},"4CBA26AF-0014-4296-85A5-8FEBE21CE4CC-233-000047350083816A_hover":{"framesPerSecond":30,"animations":[{"startValue":"0px","isRelative":true,"endValue":"0px","identifier":"TextShadowBlurRadius","duration":1,"timingFunction":"easeinout","type":0,"oid":"4CBA26AF-0014-4296-85A5-8FEBE21CE4CC-233-000047350083816A","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"BackgroundGradientStartColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"4CBA26AF-0014-4296-85A5-8FEBE21CE4CC-233-000047350083816A","startTime":0},{"startValue":"#333333","isRelative":true,"endValue":"#3C86D3","identifier":"TextColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"4CBA26AF-0014-4296-85A5-8FEBE21CE4CC-233-000047350083816A","startTime":0},{"startValue":"1px","isRelative":true,"endValue":"2px","identifier":"TextShadowYOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"4CBA26AF-0014-4296-85A5-8FEBE21CE4CC-233-000047350083816A","startTime":0},{"startValue":"0px","isRelative":true,"endValue":"1px","identifier":"TextShadowXOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"4CBA26AF-0014-4296-85A5-8FEBE21CE4CC-233-000047350083816A","startTime":0},{"startValue":"#E6E6E6","isRelative":true,"endValue":"#EFEFEF","identifier":"BackgroundGradientEndColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"4CBA26AF-0014-4296-85A5-8FEBE21CE4CC-233-000047350083816A","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"TextShadowColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"4CBA26AF-0014-4296-85A5-8FEBE21CE4CC-233-000047350083816A","startTime":0}],"identifier":"4CBA26AF-0014-4296-85A5-8FEBE21CE4CC-233-000047350083816A_hover","name":"4CBA26AF-0014-4296-85A5-8FEBE21CE4CC-233-000047350083816A_hover","duration":1},"0178DE40-F6B8-4FFE-B9AF-C57309524956-233-00004735002DB16E_hover":{"framesPerSecond":30,"animations":[{"startValue":"0px","isRelative":true,"endValue":"0px","identifier":"TextShadowBlurRadius","duration":1,"timingFunction":"easeinout","type":0,"oid":"0178DE40-F6B8-4FFE-B9AF-C57309524956-233-00004735002DB16E","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"BackgroundGradientStartColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"0178DE40-F6B8-4FFE-B9AF-C57309524956-233-00004735002DB16E","startTime":0},{"startValue":"#333333","isRelative":true,"endValue":"#3C86D3","identifier":"TextColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"0178DE40-F6B8-4FFE-B9AF-C57309524956-233-00004735002DB16E","startTime":0},{"startValue":"1px","isRelative":true,"endValue":"2px","identifier":"TextShadowYOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"0178DE40-F6B8-4FFE-B9AF-C57309524956-233-00004735002DB16E","startTime":0},{"startValue":"0px","isRelative":true,"endValue":"1px","identifier":"TextShadowXOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"0178DE40-F6B8-4FFE-B9AF-C57309524956-233-00004735002DB16E","startTime":0},{"startValue":"#E6E6E6","isRelative":true,"endValue":"#EFEFEF","identifier":"BackgroundGradientEndColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"0178DE40-F6B8-4FFE-B9AF-C57309524956-233-00004735002DB16E","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"TextShadowColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"0178DE40-F6B8-4FFE-B9AF-C57309524956-233-00004735002DB16E","startTime":0}],"identifier":"0178DE40-F6B8-4FFE-B9AF-C57309524956-233-00004735002DB16E_hover","name":"0178DE40-F6B8-4FFE-B9AF-C57309524956-233-00004735002DB16E_hover","duration":1},"ACB748AD-B732-4D36-BBAD-EB646C36D02A-233-00004734FF9067F7_hover":{"framesPerSecond":30,"animations":[{"startValue":"0px","isRelative":true,"endValue":"0px","identifier":"TextShadowBlurRadius","duration":1,"timingFunction":"easeinout","type":0,"oid":"ACB748AD-B732-4D36-BBAD-EB646C36D02A-233-00004734FF9067F7","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"BackgroundGradientStartColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"ACB748AD-B732-4D36-BBAD-EB646C36D02A-233-00004734FF9067F7","startTime":0},{"startValue":"#333333","isRelative":true,"endValue":"#3C86D3","identifier":"TextColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"ACB748AD-B732-4D36-BBAD-EB646C36D02A-233-00004734FF9067F7","startTime":0},{"startValue":"1px","isRelative":true,"endValue":"2px","identifier":"TextShadowYOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"ACB748AD-B732-4D36-BBAD-EB646C36D02A-233-00004734FF9067F7","startTime":0},{"startValue":"0px","isRelative":true,"endValue":"1px","identifier":"TextShadowXOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"ACB748AD-B732-4D36-BBAD-EB646C36D02A-233-00004734FF9067F7","startTime":0},{"startValue":"#E6E6E6","isRelative":true,"endValue":"#EFEFEF","identifier":"BackgroundGradientEndColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"ACB748AD-B732-4D36-BBAD-EB646C36D02A-233-00004734FF9067F7","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"TextShadowColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"ACB748AD-B732-4D36-BBAD-EB646C36D02A-233-00004734FF9067F7","startTime":0}],"identifier":"ACB748AD-B732-4D36-BBAD-EB646C36D02A-233-00004734FF9067F7_hover","name":"ACB748AD-B732-4D36-BBAD-EB646C36D02A-233-00004734FF9067F7_hover","duration":1}},"id":"1952F16F-11C6-44E6-8C53-F6B4588C2F70-233-0000473500C5B081","sceneIndex":3,"perspective":"600px","oid":"1952F16F-11C6-44E6-8C53-F6B4588C2F70-233-0000473500C5B081","initialValues":{"96B309EF-3E48-43F1-9E9A-15BE1DD69B61-6083-00004BD1EC2B69A9":{"Position":"absolute","BackgroundOrigin":"content-box","Display":"inline","Left":"431px","BackgroundImage":"list.png","Height":"476px","Overflow":"visible","Width":"459px","ZIndex":"17","BackgroundSize":"100% 100%","Top":"52px","BackgroundRepeat":"no-repeat","TagName":"div"},"ACB748AD-B732-4D36-BBAD-EB646C36D02A-233-00004734FF9067F7":{"ActionOnMouseClick":{"type":1,"transition":1,"sceneOid":"63312270-7D17-479F-A107-D656370C794D-73864-00015045950F244D"},"BorderStyleTop":"Solid","BackgroundColor":"#F0F0F0","WordWrap":"break-word","FontWeight":"normal","Display":"inline","BorderStyleRight":"Solid","BorderWidthBottom":"1px","BorderWidthRight":"1px","BorderWidthTop":"1px","ButtonHover":"ACB748AD-B732-4D36-BBAD-EB646C36D02A-233-00004734FF9067F7_hover","BorderStyleLeft":"Solid","BorderColorBottom":"#B3B3B3","FontSize":"14px","TextColor":"#333333","InnerHTML":"Welcome to<div>Raven for Mac</div>","Height":"36px","TextAlign":"left","ZIndex":"7","PaddingLeft":"14px","Top":"528px","BackgroundGradientStartColor":"#FFFFFF","UserSelect":"none","WhiteSpaceCollapsing":"preserve","TextShadowXOffset":"0px","BorderColorTop":"#B3B3B3","PaddingTop":"14px","TagName":"div","BorderStyleBottom":"Solid","BackgroundGradientAngle":"0deg","PaddingBottom":"14px","FontFamily":"'Helvetica Neue',Arial,Helvetica,Sans-Serif","PaddingRight":"14px","Position":"absolute","TextShadowColor":"#FFFFFF","Width":"130px","BorderColorLeft":"#B3B3B3","BorderRadiusBottomRight":"0px","Left":"31px","BorderColorRight":"#B3B3B3","BorderRadiusBottomLeft":"10px","BorderWidthLeft":"1px","TextShadowBlurRadius":"0px","TextShadowYOffset":"1px","Cursor":"pointer","BackgroundGradientEndColor":"#E6E6E6","Overflow":"visible","LetterSpacing":"0px"},"D1FCC306-C7B1-43AC-8CF2-9EC78716F7DF-233-000049DCA1552888":{"ActionOnMouseClick":{"type":1,"transition":1,"sceneOid":"E5C5FC9B-874F-4B52-8BAA-0CE133341F42-233-000049C968DF1C30"},"BorderStyleTop":"Solid","BackgroundColor":"#F0F0F0","WordWrap":"break-word","FontWeight":"normal","Display":"inline","BorderStyleRight":"Solid","BorderWidthBottom":"1px","BorderWidthRight":"1px","BorderWidthTop":"1px","ButtonHover":"D1FCC306-C7B1-43AC-8CF2-9EC78716F7DF-233-000049DCA1552888_hover","BorderStyleLeft":"Solid","BorderColorBottom":"#B3B3B3","FontSize":"14px","TextColor":"#333333","InnerHTML":"Adding Favorites<div>&amp; Bookmarks</div>","Height":"36px","TextAlign":"left","ZIndex":"16","PaddingLeft":"14px","Top":"528px","BackgroundGradientStartColor":"#FFFFFF","UserSelect":"none","WhiteSpaceCollapsing":"preserve","TextShadowXOffset":"0px","BorderColorTop":"#B3B3B3","PaddingTop":"14px","TagName":"div","BorderStyleBottom":"Solid","BackgroundGradientAngle":"0deg","PaddingBottom":"14px","FontFamily":"'Helvetica Neue',Arial,Helvetica,Sans-Serif","PaddingRight":"14px","Position":"absolute","TextShadowColor":"#FFFFFF","Width":"146px","BorderColorLeft":"#B3B3B3","BorderRadiusBottomRight":"0px","Left":"351px","BorderColorRight":"#B3B3B3","BorderRadiusBottomLeft":"0px","BorderWidthLeft":"1px","TextShadowBlurRadius":"0px","TextShadowYOffset":"1px","Cursor":"pointer","BackgroundGradientEndColor":"#E6E6E6","Overflow":"visible","LetterSpacing":"0px"},"3A64A687-B2AF-4DF0-805E-D1353FFF2356-233-0000473500770176":{"FontFamily":"'Helvetica Neue',Arial,Helvetica,Sans-Serif","TagName":"div","PaddingRight":"8px","FontSize":"17px","Display":"inline","WordWrap":"break-word","PaddingBottom":"8px","Top":"241px","UserSelect":"none","WhiteSpaceCollapsing":"preserve","Position":"absolute","Height":"219px","Left":"72px","InnerHTML":"<div>You can browser your bookmarks by clicking on the star icon in the Smart Bar.<br></div><div><br></div><div>This will reveal a list of pages you've saved to read later. Simply select one to view it in the preview pane.</div><div><br></div><div>By clicking the \"T\" icon you can read the article in text only mode. Now you can enjoy reading without all the clutter.</div>","ZIndex":"13","Width":"332px","PaddingLeft":"8px","PaddingTop":"8px","Overflow":"visible","TextColor":"#666666"},"0178DE40-F6B8-4FFE-B9AF-C57309524956-233-00004735002DB16E":{"ActionOnMouseClick":{"type":1,"transition":1,"sceneOid":"62A7DFA9-2B38-49E6-9694-0E4FE9F8B2E8-233-000044404F9F937D"},"BorderStyleTop":"Solid","BackgroundColor":"#F0F0F0","WordWrap":"break-word","FontWeight":"normal","Display":"inline","BorderStyleRight":"Solid","BorderWidthBottom":"1px","BorderWidthRight":"1px","BorderWidthTop":"1px","ButtonHover":"0178DE40-F6B8-4FFE-B9AF-C57309524956-233-00004735002DB16E_hover","BorderStyleLeft":"Solid","BorderColorBottom":"#B3B3B3","FontSize":"14px","TextColor":"#333333","InnerHTML":"<div style=\"-webkit-transform: rotateY(0deg); \">Build Your Web</div><div style=\"-webkit-transform: rotateY(0deg); \">App Library</div>","Height":"36px","TextAlign":"left","ZIndex":"8","PaddingLeft":"14px","Top":"528px","BackgroundGradientStartColor":"#FFFFFF","UserSelect":"none","WhiteSpaceCollapsing":"preserve","TextShadowXOffset":"0px","BorderColorTop":"#B3B3B3","PaddingTop":"14px","TagName":"div","BorderStyleBottom":"Solid","BackgroundGradientAngle":"0deg","PaddingBottom":"14px","FontFamily":"'Helvetica Neue',Arial,Helvetica,Sans-Serif","PaddingRight":"14px","Position":"absolute","TextShadowColor":"#FFFFFF","Width":"136px","BorderColorLeft":"#B3B3B3","BorderRadiusBottomRight":"0px","Left":"185px","BorderColorRight":"#B3B3B3","BorderRadiusBottomLeft":"0px","BorderWidthLeft":"1px","TextShadowBlurRadius":"0px","TextShadowYOffset":"1px","Cursor":"pointer","BackgroundGradientEndColor":"#E6E6E6","Overflow":"visible","LetterSpacing":"0px"},"54868F4B-9B75-4800-B51C-4C4E8CCD6C7E-233-00004734FF7F0F79":{"FontFamily":"Helvetica,Arial,Sans-Serif","FontWeight":"normal","TagName":"div","PaddingRight":"8px","FontSize":"48px","LetterSpacing":"-2px","Display":"inline","WordWrap":"break-word","PaddingBottom":"8px","Top":"112px","UserSelect":"none","WhiteSpaceCollapsing":"preserve","Position":"absolute","Height":"97px","Left":"72px","InnerHTML":"Browsing your<div>Bookmarks</div>","ZIndex":"12","PaddingLeft":"8px","Width":"372px","PaddingTop":"8px","Overflow":"visible","TextColor":"#000000"},"14DBAED9-5BA6-420F-BA08-93E7589C777E-233-00004734FFDA4485":{"BorderWidthLeft":"1px","TagName":"div","BorderColorBottom":"#A0A0A0","BorderStyleRight":"Solid","BorderStyleBottom":"Solid","BoxShadowBlurRadius":"5px","Top":"23px","BorderStyleLeft":"Solid","BorderWidthRight":"1px","BorderColorTop":"#A0A0A0","BorderColorLeft":"#A0A0A0","BoxShadowYOffset":"0px","UserSelect":"none","Position":"absolute","Height":"569px","Left":"31px","BoxShadowColor":"#959595","BorderColorRight":"#A0A0A0","BorderStyleTop":"Solid","BorderRadiusTopLeft":"10px","ZIndex":"1","Width":"858px","BorderWidthTop":"1px","BoxShadowXOffset":"0px","BorderRadiusBottomLeft":"10px","BorderRadiusTopRight":"10px","Overflow":"visible","BorderRadiusBottomRight":"10px","BorderWidthBottom":"1px","BackgroundColor":"#FFFFFF"},"4CBA26AF-0014-4296-85A5-8FEBE21CE4CC-233-000047350083816A":{"ActionOnMouseClick":{"type":1,"transition":1,"sceneOid":"D31FB37E-5520-48E5-A0C3-6F9BA7834791-233-00004BCF153486D2"},"BorderStyleTop":"Solid","BackgroundColor":"#F0F0F0","WordWrap":"break-word","FontWeight":"normal","Display":"inline","BorderStyleRight":"Solid","BorderWidthBottom":"1px","BorderWidthRight":"1px","BorderWidthTop":"1px","ButtonHover":"4CBA26AF-0014-4296-85A5-8FEBE21CE4CC-233-000047350083816A_hover","BorderStyleLeft":"Solid","BorderColorBottom":"#B3B3B3","FontSize":"14px","TextColor":"#333333","InnerHTML":"Visting the<div>Web App Shop</div>","Height":"36px","TextAlign":"left","ZIndex":"9","PaddingLeft":"14px","Top":"528px","BackgroundGradientStartColor":"#FFFFFF","UserSelect":"none","WhiteSpaceCollapsing":"preserve","TextShadowXOffset":"0px","BorderColorTop":"#B3B3B3","PaddingTop":"14px","TagName":"div","BorderStyleBottom":"Solid","BackgroundGradientAngle":"0deg","PaddingBottom":"14px","FontFamily":"'Helvetica Neue',Arial,Helvetica,Sans-Serif","PaddingRight":"14px","Position":"absolute","TextShadowColor":"#FFFFFF","Width":"160px","BorderColorLeft":"#B3B3B3","BorderRadiusBottomRight":"10px","Left":"701px","BorderColorRight":"#B3B3B3","BorderRadiusBottomLeft":"0px","BorderWidthLeft":"1px","TextShadowBlurRadius":"0px","TextShadowYOffset":"1px","Cursor":"pointer","BackgroundGradientEndColor":"#E6E6E6","Overflow":"visible","LetterSpacing":"0px"},"92E5A5A5-60D2-4964-9A64-6CC554184D87-233-000049D81F1C185C":{"BorderStyleTop":"Solid","BorderStyleRight":"Solid","BackgroundColor":"#F0F0F0","WordWrap":"break-word","FontWeight":"normal","Display":"inline","BorderWidthBottom":"1px","BorderWidthRight":"1px","BorderWidthTop":"1px","ButtonHover":"92E5A5A5-60D2-4964-9A64-6CC554184D87-233-000049D81F1C185C_hover","BorderStyleLeft":"Solid","BorderColorBottom":"#B3B3B3","FontSize":"14px","TextColor":"#000000","InnerHTML":"Browsing your<div>Bookmarks</div>","Height":"36px","TextAlign":"left","ZIndex":"15","PaddingLeft":"14px","Top":"528px","BackgroundGradientStartColor":"#E6E6E6","UserSelect":"none","WhiteSpaceCollapsing":"preserve","TextShadowXOffset":"0px","BorderColorTop":"#B3B3B3","PaddingTop":"14px","TagName":"div","BorderStyleBottom":"Solid","BackgroundGradientAngle":"0deg","PaddingBottom":"14px","FontFamily":"'Helvetica Neue',Arial,Helvetica,Sans-Serif","PaddingRight":"14px","Position":"absolute","TextShadowColor":"#FFFFFF","Width":"151px","BorderColorLeft":"#B3B3B3","BorderRadiusBottomRight":"0px","Left":"525px","BorderColorRight":"#B3B3B3","BorderRadiusBottomLeft":"0px","BorderWidthLeft":"1px","TextShadowBlurRadius":"0px","TextShadowYOffset":"1px","Cursor":"pointer","BackgroundGradientEndColor":"#FFFFFF","Overflow":"visible","LetterSpacing":"0px"}},"name":"Install","backgroundColor":"#E2E4E2"},{"timelines":{"97D00DB8-43C6-47EF-8F0A-14C23D8C1F8A-233-00004BCF144927E5_hover":{"framesPerSecond":30,"animations":[{"startValue":"0px","isRelative":true,"endValue":"0px","identifier":"TextShadowBlurRadius","duration":1,"timingFunction":"easeinout","type":0,"oid":"97D00DB8-43C6-47EF-8F0A-14C23D8C1F8A-233-00004BCF144927E5","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"BackgroundGradientStartColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"97D00DB8-43C6-47EF-8F0A-14C23D8C1F8A-233-00004BCF144927E5","startTime":0},{"startValue":"#333333","isRelative":true,"endValue":"#3C86D3","identifier":"TextColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"97D00DB8-43C6-47EF-8F0A-14C23D8C1F8A-233-00004BCF144927E5","startTime":0},{"startValue":"1px","isRelative":true,"endValue":"2px","identifier":"TextShadowYOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"97D00DB8-43C6-47EF-8F0A-14C23D8C1F8A-233-00004BCF144927E5","startTime":0},{"startValue":"0px","isRelative":true,"endValue":"1px","identifier":"TextShadowXOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"97D00DB8-43C6-47EF-8F0A-14C23D8C1F8A-233-00004BCF144927E5","startTime":0},{"startValue":"#E6E6E6","isRelative":true,"endValue":"#EFEFEF","identifier":"BackgroundGradientEndColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"97D00DB8-43C6-47EF-8F0A-14C23D8C1F8A-233-00004BCF144927E5","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"TextShadowColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"97D00DB8-43C6-47EF-8F0A-14C23D8C1F8A-233-00004BCF144927E5","startTime":0}],"identifier":"97D00DB8-43C6-47EF-8F0A-14C23D8C1F8A-233-00004BCF144927E5_hover","name":"97D00DB8-43C6-47EF-8F0A-14C23D8C1F8A-233-00004BCF144927E5_hover","duration":1},"D58BDDE7-8AF8-4A9A-974B-981674B51BD2-233-00004BCF14F57960_hover":{"framesPerSecond":30,"animations":[{"startValue":"0px","isRelative":true,"endValue":"0px","identifier":"TextShadowBlurRadius","duration":1,"timingFunction":"easeinout","type":0,"oid":"D58BDDE7-8AF8-4A9A-974B-981674B51BD2-233-00004BCF14F57960","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"BackgroundGradientStartColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"D58BDDE7-8AF8-4A9A-974B-981674B51BD2-233-00004BCF14F57960","startTime":0},{"startValue":"#333333","isRelative":true,"endValue":"#3C86D3","identifier":"TextColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"D58BDDE7-8AF8-4A9A-974B-981674B51BD2-233-00004BCF14F57960","startTime":0},{"startValue":"1px","isRelative":true,"endValue":"2px","identifier":"TextShadowYOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"D58BDDE7-8AF8-4A9A-974B-981674B51BD2-233-00004BCF14F57960","startTime":0},{"startValue":"0px","isRelative":true,"endValue":"1px","identifier":"TextShadowXOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"D58BDDE7-8AF8-4A9A-974B-981674B51BD2-233-00004BCF14F57960","startTime":0},{"startValue":"#E6E6E6","isRelative":true,"endValue":"#EFEFEF","identifier":"BackgroundGradientEndColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"D58BDDE7-8AF8-4A9A-974B-981674B51BD2-233-00004BCF14F57960","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"TextShadowColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"D58BDDE7-8AF8-4A9A-974B-981674B51BD2-233-00004BCF14F57960","startTime":0}],"identifier":"D58BDDE7-8AF8-4A9A-974B-981674B51BD2-233-00004BCF14F57960_hover","name":"D58BDDE7-8AF8-4A9A-974B-981674B51BD2-233-00004BCF14F57960_hover","duration":1},"576DA9BD-73EF-4CF2-88E1-2A17C795E05D-233-00004E1809DB06C8_hover":{"framesPerSecond":30,"animations":[{"startValue":"#FFFFFF","isRelative":true,"endValue":"#D8D8D8","identifier":"BackgroundGradientStartColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"576DA9BD-73EF-4CF2-88E1-2A17C795E05D-233-00004E1809DB06C8","startTime":0},{"startValue":"#D8D8D8","isRelative":true,"endValue":"#FFFFFF","identifier":"BackgroundGradientEndColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"576DA9BD-73EF-4CF2-88E1-2A17C795E05D-233-00004E1809DB06C8","startTime":0},{"startValue":"1px","isRelative":true,"endValue":"0px","identifier":"BoxShadowYOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"576DA9BD-73EF-4CF2-88E1-2A17C795E05D-233-00004E1809DB06C8","startTime":0},{"startValue":"3px","isRelative":true,"endValue":"0px","identifier":"BoxShadowBlurRadius","duration":1,"timingFunction":"easeinout","type":0,"oid":"576DA9BD-73EF-4CF2-88E1-2A17C795E05D-233-00004E1809DB06C8","startTime":0}],"identifier":"576DA9BD-73EF-4CF2-88E1-2A17C795E05D-233-00004E1809DB06C8_hover","name":"576DA9BD-73EF-4CF2-88E1-2A17C795E05D-233-00004E1809DB06C8_hover","duration":1},"53091E91-1D9D-497D-8378-8EC3EF77D87A-233-00004C3E4B227485_hover":{"framesPerSecond":30,"animations":[{"startValue":"0px","isRelative":true,"endValue":"0px","identifier":"TextShadowBlurRadius","duration":1,"timingFunction":"easeinout","type":0,"oid":"53091E91-1D9D-497D-8378-8EC3EF77D87A-233-00004C3E4B227485","startTime":0},{"startValue":"#E6E6E6","isRelative":true,"endValue":"#EFEFEF","identifier":"BackgroundGradientStartColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"53091E91-1D9D-497D-8378-8EC3EF77D87A-233-00004C3E4B227485","startTime":0},{"startValue":"#000000","isRelative":true,"endValue":"#000000","identifier":"TextColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"53091E91-1D9D-497D-8378-8EC3EF77D87A-233-00004C3E4B227485","startTime":0},{"startValue":"1px","isRelative":true,"endValue":"2px","identifier":"TextShadowYOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"53091E91-1D9D-497D-8378-8EC3EF77D87A-233-00004C3E4B227485","startTime":0},{"startValue":"0px","isRelative":true,"endValue":"1px","identifier":"TextShadowXOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"53091E91-1D9D-497D-8378-8EC3EF77D87A-233-00004C3E4B227485","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"BackgroundGradientEndColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"53091E91-1D9D-497D-8378-8EC3EF77D87A-233-00004C3E4B227485","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"TextShadowColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"53091E91-1D9D-497D-8378-8EC3EF77D87A-233-00004C3E4B227485","startTime":0}],"identifier":"53091E91-1D9D-497D-8378-8EC3EF77D87A-233-00004C3E4B227485_hover","name":"53091E91-1D9D-497D-8378-8EC3EF77D87A-233-00004C3E4B227485_hover","duration":1},"F8C59BF0-F8FB-4FBB-B579-93B459F9DA0F-233-00004BCF1492E65D_hover":{"framesPerSecond":30,"animations":[{"startValue":"0px","isRelative":true,"endValue":"0px","identifier":"TextShadowBlurRadius","duration":1,"timingFunction":"easeinout","type":0,"oid":"F8C59BF0-F8FB-4FBB-B579-93B459F9DA0F-233-00004BCF1492E65D","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"BackgroundGradientStartColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"F8C59BF0-F8FB-4FBB-B579-93B459F9DA0F-233-00004BCF1492E65D","startTime":0},{"startValue":"#333333","isRelative":true,"endValue":"#3C86D3","identifier":"TextColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"F8C59BF0-F8FB-4FBB-B579-93B459F9DA0F-233-00004BCF1492E65D","startTime":0},{"startValue":"1px","isRelative":true,"endValue":"2px","identifier":"TextShadowYOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"F8C59BF0-F8FB-4FBB-B579-93B459F9DA0F-233-00004BCF1492E65D","startTime":0},{"startValue":"0px","isRelative":true,"endValue":"1px","identifier":"TextShadowXOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"F8C59BF0-F8FB-4FBB-B579-93B459F9DA0F-233-00004BCF1492E65D","startTime":0},{"startValue":"#E6E6E6","isRelative":true,"endValue":"#EFEFEF","identifier":"BackgroundGradientEndColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"F8C59BF0-F8FB-4FBB-B579-93B459F9DA0F-233-00004BCF1492E65D","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"TextShadowColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"F8C59BF0-F8FB-4FBB-B579-93B459F9DA0F-233-00004BCF1492E65D","startTime":0}],"identifier":"F8C59BF0-F8FB-4FBB-B579-93B459F9DA0F-233-00004BCF1492E65D_hover","name":"F8C59BF0-F8FB-4FBB-B579-93B459F9DA0F-233-00004BCF1492E65D_hover","duration":1},"77B102A5-D518-4840-8887-02278E20ADB3-233-00004BCF1404C84F_hover":{"framesPerSecond":30,"animations":[{"startValue":"0px","isRelative":true,"endValue":"0px","identifier":"TextShadowBlurRadius","duration":1,"timingFunction":"easeinout","type":0,"oid":"77B102A5-D518-4840-8887-02278E20ADB3-233-00004BCF1404C84F","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"BackgroundGradientStartColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"77B102A5-D518-4840-8887-02278E20ADB3-233-00004BCF1404C84F","startTime":0},{"startValue":"#333333","isRelative":true,"endValue":"#3C86D3","identifier":"TextColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"77B102A5-D518-4840-8887-02278E20ADB3-233-00004BCF1404C84F","startTime":0},{"startValue":"1px","isRelative":true,"endValue":"2px","identifier":"TextShadowYOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"77B102A5-D518-4840-8887-02278E20ADB3-233-00004BCF1404C84F","startTime":0},{"startValue":"0px","isRelative":true,"endValue":"1px","identifier":"TextShadowXOffset","duration":1,"timingFunction":"easeinout","type":0,"oid":"77B102A5-D518-4840-8887-02278E20ADB3-233-00004BCF1404C84F","startTime":0},{"startValue":"#E6E6E6","isRelative":true,"endValue":"#EFEFEF","identifier":"BackgroundGradientEndColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"77B102A5-D518-4840-8887-02278E20ADB3-233-00004BCF1404C84F","startTime":0},{"startValue":"#FFFFFF","isRelative":true,"endValue":"#FFFFFF","identifier":"TextShadowColor","duration":1,"timingFunction":"easeinout","type":0,"oid":"77B102A5-D518-4840-8887-02278E20ADB3-233-00004BCF1404C84F","startTime":0}],"identifier":"77B102A5-D518-4840-8887-02278E20ADB3-233-00004BCF1404C84F_hover","name":"77B102A5-D518-4840-8887-02278E20ADB3-233-00004BCF1404C84F_hover","duration":1},"kTimelineDefaultIdentifier":{"framesPerSecond":30,"animations":[],"identifier":"kTimelineDefaultIdentifier","name":"Main Timeline","duration":0}},"id":"D31FB37E-5520-48E5-A0C3-6F9BA7834791-233-00004BCF153486D2","sceneIndex":4,"perspective":"600px","oid":"D31FB37E-5520-48E5-A0C3-6F9BA7834791-233-00004BCF153486D2","initialValues":{"97D00DB8-43C6-47EF-8F0A-14C23D8C1F8A-233-00004BCF144927E5":{"ActionOnMouseClick":{"type":1,"transition":1,"sceneOid":"63312270-7D17-479F-A107-D656370C794D-73864-00015045950F244D"},"BorderStyleTop":"Solid","BackgroundColor":"#F0F0F0","WordWrap":"break-word","FontWeight":"normal","Display":"inline","BorderStyleRight":"Solid","BorderWidthBottom":"1px","BorderWidthRight":"1px","BorderWidthTop":"1px","ButtonHover":"97D00DB8-43C6-47EF-8F0A-14C23D8C1F8A-233-00004BCF144927E5_hover","BorderStyleLeft":"Solid","BorderColorBottom":"#B3B3B3","FontSize":"14px","TextColor":"#333333","InnerHTML":"Welcome to<div>Raven for Mac</div>","Height":"36px","TextAlign":"left","ZIndex":"9","PaddingLeft":"14px","Top":"528px","BackgroundGradientStartColor":"#FFFFFF","UserSelect":"none","WhiteSpaceCollapsing":"preserve","TextShadowXOffset":"0px","BorderColorTop":"#B3B3B3","PaddingTop":"14px","TagName":"div","BorderStyleBottom":"Solid","BackgroundGradientAngle":"0deg","PaddingBottom":"14px","FontFamily":"'Helvetica Neue',Arial,Helvetica,Sans-Serif","PaddingRight":"14px","Position":"absolute","TextShadowColor":"#FFFFFF","Width":"130px","BorderColorLeft":"#B3B3B3","BorderRadiusBottomRight":"0px","Left":"31px","BorderColorRight":"#B3B3B3","BorderRadiusBottomLeft":"10px","BorderWidthLeft":"1px","TextShadowBlurRadius":"0px","TextShadowYOffset":"1px","Cursor":"pointer","BackgroundGradientEndColor":"#E6E6E6","Overflow":"visible","LetterSpacing":"0px"},"F1636CBD-3CDA-441D-9F37-24A3473BD89E-233-00004BCF148743D7":{"FontFamily":"Helvetica,Arial,Sans-Serif","FontWeight":"normal","TagName":"div","PaddingRight":"8px","FontSize":"48px","LetterSpacing":"-2px","Display":"inline","WordWrap":"break-word","PaddingBottom":"8px","Top":"118px","UserSelect":"none","WhiteSpaceCollapsing":"preserve","Position":"absolute","Height":"97px","Left":"72px","InnerHTML":"<div>Visiting the</div><div>Web App Shop</div>","ZIndex":"21","PaddingLeft":"8px","Width":"372px","PaddingTop":"8px","Overflow":"visible","TextColor":"#000000"},"F8C59BF0-F8FB-4FBB-B579-93B459F9DA0F-233-00004BCF1492E65D":{"ActionOnMouseClick":{"type":1,"transition":1,"sceneOid":"62A7DFA9-2B38-49E6-9694-0E4FE9F8B2E8-233-000044404F9F937D"},"BorderStyleTop":"Solid","BackgroundColor":"#F0F0F0","WordWrap":"break-word","FontWeight":"normal","Display":"inline","BorderStyleRight":"Solid","BorderWidthBottom":"1px","BorderWidthRight":"1px","BorderWidthTop":"1px","ButtonHover":"F8C59BF0-F8FB-4FBB-B579-93B459F9DA0F-233-00004BCF1492E65D_hover","BorderStyleLeft":"Solid","BorderColorBottom":"#B3B3B3","FontSize":"14px","TextColor":"#333333","InnerHTML":"<div style=\"-webkit-transform: rotateY(0deg); \">Build Your Web</div><div style=\"-webkit-transform: rotateY(0deg); \">App Library</div>","Height":"36px","TextAlign":"left","ZIndex":"10","PaddingLeft":"14px","Top":"528px","BackgroundGradientStartColor":"#FFFFFF","UserSelect":"none","WhiteSpaceCollapsing":"preserve","TextShadowXOffset":"0px","BorderColorTop":"#B3B3B3","PaddingTop":"14px","TagName":"div","BorderStyleBottom":"Solid","BackgroundGradientAngle":"0deg","PaddingBottom":"14px","FontFamily":"'Helvetica Neue',Arial,Helvetica,Sans-Serif","PaddingRight":"14px","Position":"absolute","TextShadowColor":"#FFFFFF","Width":"136px","BorderColorLeft":"#B3B3B3","BorderRadiusBottomRight":"0px","Left":"185px","BorderColorRight":"#B3B3B3","BorderRadiusBottomLeft":"0px","BorderWidthLeft":"1px","TextShadowBlurRadius":"0px","TextShadowYOffset":"1px","Cursor":"pointer","BackgroundGradientEndColor":"#E6E6E6","Overflow":"visible","LetterSpacing":"0px"},"649EB76E-8845-4F6C-9765-1EE784C11B1F-233-00004E180AF6ACCE":{"Position":"absolute","BackgroundOrigin":"content-box","Display":"inline","UserSelect":"none","BackgroundImage":"arrow.png","Left":"287px","Cursor":"pointer","Overflow":"visible","BackgroundSize":"100% 100%","ZIndex":"24","Height":"15px","ActionOnMouseClick":{"goToURL":"http://start.raven.io","type":5,"openInNewWindow":false},"Width":"15px","Top":"421px","TagName":"div"},"43EF320D-E669-4FB8-80A0-63A91181BA33-233-00004C3044EDEBFB":{"FontFamily":"'Helvetica Neue',Arial,Helvetica,Sans-Serif","TagName":"div","PaddingRight":"8px","FontSize":"17px","Display":"inline","WordWrap":"break-word","PaddingBottom":"8px","Top":"246px","UserSelect":"none","WhiteSpaceCollapsing":"preserve","Position":"absolute","Height":"129px","Left":"79px","InnerHTML":"Discover web apps, sites, social networks and games at the new Web App Shop.<div><br></div><div>You can add an web app to your Smart Bar by simply clicking the install button. You'll be prompted to install, click okay and it is yours.</div>","ZIndex":"20","Width":"355px","PaddingLeft":"8px","PaddingTop":"8px","Overflow":"visible","TextColor":"#666666"},"576DA9BD-73EF-4CF2-88E1-2A17C795E05D-233-00004E1809DB06C8":{"PaddingBottom":"10px","BorderWidthLeft":"1px","Display":"inline","TagName":"div","BorderColorLeft":"#A0A0A0","UserSelect":"none","Overflow":"visible","TextAlign":"left","LineHeight":"17px","BoxShadowBlurRadius":"3px","BorderColorTop":"#A0A0A0","BackgroundGradientAngle":"0deg","ActionOnMouseClick":{"goToURL":"http://start.raven.io","type":5,"openInNewWindow":false},"BorderWidthBottom":"1px","WordSpacing":"0px","BorderStyleRight":"Solid","ZIndex":"23","BorderRadiusBottomRight":"6px","FontSize":"16px","BackgroundGradientStartColor":"#FFFFFF","Width":"209px","TextShadowXOffset":"0px","BorderColorRight":"#A0A0A0","BoxShadowColor":"#AFAFAF","PaddingLeft":"10px","BoxShadowXOffset":"0px","BorderColorBottom":"#A0A0A0","BoxShadowYOffset":"1px","Cursor":"pointer","Position":"absolute","BorderStyleTop":"Solid","TextShadowColor":"#FFFFFF","BorderRadiusBottomLeft":"6px","BorderRadiusTopLeft":"6px","Left":"84px","BorderRadiusTopRight":"6px","BorderStyleBottom":"Solid","Height":"20px","PaddingRight":"10px","FontWeight":"bold","WhiteSpaceCollapsing":"preserve","PaddingTop":"10px","BackgroundColor":"#F0F0F0","TextColor":"#0051A1","BorderWidthTop":"1px","Top":"406px","TextShadowBlurRadius":"0px","TextShadowYOffset":"1px","InnerHTML":"Visit the Web App Shop","WordWrap":"break-word","BackgroundGradientEndColor":"#D8D8D8","BorderStyleLeft":"Solid","BorderWidthRight":"1px","ButtonHover":"576DA9BD-73EF-4CF2-88E1-2A17C795E05D-233-00004E1809DB06C8_hover"},"77B102A5-D518-4840-8887-02278E20ADB3-233-00004BCF1404C84F":{"ActionOnMouseClick":{"type":1,"transition":1,"sceneOid":"E5C5FC9B-874F-4B52-8BAA-0CE133341F42-233-000049C968DF1C30"},"BorderStyleTop":"Solid","BackgroundColor":"#F0F0F0","WordWrap":"break-word","FontWeight":"normal","Display":"inline","BorderStyleRight":"Solid","BorderWidthBottom":"1px","BorderWidthRight":"1px","BorderWidthTop":"1px","ButtonHover":"77B102A5-D518-4840-8887-02278E20ADB3-233-00004BCF1404C84F_hover","BorderStyleLeft":"Solid","BorderColorBottom":"#B3B3B3","FontSize":"14px","TextColor":"#333333","InnerHTML":"Adding Favorites<div>&amp; Bookmarks</div>","Height":"36px","TextAlign":"left","ZIndex":"17","PaddingLeft":"14px","Top":"528px","BackgroundGradientStartColor":"#FFFFFF","UserSelect":"none","WhiteSpaceCollapsing":"preserve","TextShadowXOffset":"0px","BorderColorTop":"#B3B3B3","PaddingTop":"14px","TagName":"div","BorderStyleBottom":"Solid","BackgroundGradientAngle":"0deg","PaddingBottom":"14px","FontFamily":"'Helvetica Neue',Arial,Helvetica,Sans-Serif","PaddingRight":"14px","Position":"absolute","TextShadowColor":"#FFFFFF","Width":"146px","BorderColorLeft":"#B3B3B3","BorderRadiusBottomRight":"0px","Left":"350px","BorderColorRight":"#B3B3B3","BorderRadiusBottomLeft":"0px","BorderWidthLeft":"1px","TextShadowBlurRadius":"0px","TextShadowYOffset":"1px","Cursor":"pointer","BackgroundGradientEndColor":"#E6E6E6","Overflow":"visible","LetterSpacing":"0px"},"53091E91-1D9D-497D-8378-8EC3EF77D87A-233-00004C3E4B227485":{"BorderStyleTop":"Solid","BorderStyleRight":"Solid","BackgroundColor":"#F0F0F0","WordWrap":"break-word","FontWeight":"normal","Display":"inline","BorderWidthBottom":"1px","BorderWidthRight":"1px","BorderWidthTop":"1px","ButtonHover":"53091E91-1D9D-497D-8378-8EC3EF77D87A-233-00004C3E4B227485_hover","BorderStyleLeft":"Solid","BorderColorBottom":"#B3B3B3","FontSize":"14px","BorderRadiusTopRight":"0px","TextColor":"#000000","InnerHTML":"Visiting the<div>Web App Shop</div>","Height":"36px","TextAlign":"left","ZIndex":"22","PaddingLeft":"14px","Top":"528px","BackgroundGradientStartColor":"#E6E6E6","UserSelect":"none","WhiteSpaceCollapsing":"preserve","TextShadowXOffset":"0px","BorderColorTop":"#B3B3B3","PaddingTop":"14px","TagName":"div","BorderStyleBottom":"Solid","BackgroundGradientAngle":"0deg","PaddingBottom":"14px","FontFamily":"'Helvetica Neue',Arial,Helvetica,Sans-Serif","PaddingRight":"14px","Position":"absolute","TextShadowColor":"#FFFFFF","Width":"155px","BorderColorLeft":"#B3B3B3","BorderRadiusBottomRight":"10px","Left":"706px","BorderColorRight":"#B3B3B3","BorderRadiusBottomLeft":"0px","BorderRadiusTopLeft":"0px","BorderWidthLeft":"1px","TextShadowBlurRadius":"0px","TextShadowYOffset":"1px","Cursor":"pointer","BackgroundGradientEndColor":"#FFFFFF","Overflow":"visible","LetterSpacing":"0px"},"4CBB5732-986D-4EF7-AD14-49A7A9A79531-6083-00004B48C7AA9DB8":{"PaddingTop":"8px","Position":"absolute","TagName":"div","PaddingRight":"8px","Display":"inline","Left":"373px","Overflow":"visible","ZIndex":"25","FontSize":"10px","TextColor":"#000000","WordWrap":"break-word","WhiteSpaceCollapsing":"preserve","PaddingBottom":"8px","PaddingLeft":"8px","Top":"182px","InnerHTML":"TM"},"916CDDF3-2133-4653-8AE1-F1EF7728A2F1-233-00004BCF14DAD12F":{"BorderWidthLeft":"1px","TagName":"div","BorderColorBottom":"#A0A0A0","BorderStyleRight":"Solid","BorderStyleBottom":"Solid","BoxShadowBlurRadius":"5px","Top":"23px","BorderStyleLeft":"Solid","BorderWidthRight":"1px","BorderColorTop":"#A0A0A0","BorderColorLeft":"#A0A0A0","BoxShadowYOffset":"0px","UserSelect":"none","Position":"absolute","Height":"569px","Left":"31px","BoxShadowColor":"#959595","BorderColorRight":"#A0A0A0","BorderStyleTop":"Solid","BorderRadiusTopLeft":"10px","ZIndex":"1","Width":"858px","BorderWidthTop":"1px","BoxShadowXOffset":"0px","BorderRadiusBottomLeft":"10px","BorderRadiusTopRight":"10px","Overflow":"visible","BorderRadiusBottomRight":"10px","BorderWidthBottom":"1px","BackgroundColor":"#FFFFFF"},"D58BDDE7-8AF8-4A9A-974B-981674B51BD2-233-00004BCF14F57960":{"ActionOnMouseClick":{"type":1,"transition":1,"sceneOid":"1952F16F-11C6-44E6-8C53-F6B4588C2F70-233-0000473500C5B081"},"BorderStyleTop":"Solid","BackgroundColor":"#F0F0F0","WordWrap":"break-word","FontWeight":"normal","Display":"inline","BorderStyleRight":"Solid","BorderWidthBottom":"1px","BorderWidthRight":"1px","BorderWidthTop":"1px","ButtonHover":"D58BDDE7-8AF8-4A9A-974B-981674B51BD2-233-00004BCF14F57960_hover","BorderStyleLeft":"Solid","BorderColorBottom":"#B3B3B3","FontSize":"14px","TextColor":"#333333","InnerHTML":"<span class=\"Apple-style-span\" style=\"color: rgb(0, 0, 0); \">Browsing your<div style=\"-webkit-transform: rotateY(0deg); \">Bookmarks</div></span>","Height":"36px","TextAlign":"left","ZIndex":"11","PaddingLeft":"14px","Top":"528px","BackgroundGradientStartColor":"#FFFFFF","UserSelect":"none","WhiteSpaceCollapsing":"preserve","TextShadowXOffset":"0px","BorderColorTop":"#B3B3B3","PaddingTop":"14px","TagName":"div","BorderStyleBottom":"Solid","BackgroundGradientAngle":"0deg","PaddingBottom":"14px","FontFamily":"'Helvetica Neue',Arial,Helvetica,Sans-Serif","PaddingRight":"14px","Position":"absolute","TextShadowColor":"#FFFFFF","Width":"160px","BorderColorLeft":"#B3B3B3","BorderRadiusBottomRight":"0px","Left":"525px","BorderColorRight":"#B3B3B3","BorderRadiusBottomLeft":"0px","BorderWidthLeft":"1px","TextShadowBlurRadius":"0px","TextShadowYOffset":"1px","Cursor":"pointer","BackgroundGradientEndColor":"#E6E6E6","Overflow":"visible","LetterSpacing":"0px"},"BB7E1AA1-AB57-40A0-A8C2-F3005B453D7A-233-00004D6FFC609E15":{"Position":"absolute","BackgroundOrigin":"content-box","Display":"inline","Left":"424px","BackgroundImage":"apps-1.png","Height":"504px","Overflow":"visible","Width":"466px","ZIndex":"2","BackgroundSize":"100% 100%","Top":"64px","BackgroundRepeat":"no-repeat","TagName":"div"}},"name":"App Shop","backgroundColor":"#E2E4E2"}];

var javascriptMapping = {};


	
	var Custom = (function() {
	return {
	};
}());

	
	var hypeDoc = new HYPE();
	
	hypeDoc.attributeTransformerMapping = attributeTransformerMapping;
	hypeDoc.scenes = scenes;
	hypeDoc.javascriptMapping = javascriptMapping;
	hypeDoc.Custom = Custom;
	hypeDoc.currentSceneIndex = 0;
	hypeDoc.mainContentContainerID = "index_hype_container";
	hypeDoc.resourcesFolderName = resourcesFolderName;
	hypeDoc.showHypeBuiltWatermark = 0;
	hypeDoc.showLoadingPage = false;
	hypeDoc.drawSceneBackgrounds = true;
	hypeDoc.documentName = documentName;

	HYPE.documents[documentName] = hypeDoc.API;

	hypeDoc.documentLoad(this.body);
}());

