# import bpy
# import random
# import math
# import pickle
# import math
# from ..utils import définirPixel
# from bpy.types import Node
# from . import Node, DirectionalPoint2d, Rect2d, DirectionalPoints2dCollection
#
#
# class DirectionalPoint2dCollectionRandomGenerator():
# 	default_rect2d = Rect2d((0, 0), (250, 250))
#
# 	def __init__(self):
# 		self.parent_generator = None
# 		self.random_seed = None
# 		self.total_points_to_place = 10
# 		self.rect2d_override_parent = None
# 		self.safe_border_distance = 10
# 		self.should_clump_towards_center = True
# 		self.clumping_factor = 1
#
# 	def get_DirectionalPoint2dCollection(self):
# 		rect2d = self.getRect2d()
# 		if self.parent_generator:
# 			pointsCollection = self.parent_generator.get_DirectionalPoint2dCollection()
# 			# aggrandir le rect final si nécessaire
# 			newMinPoint = (min(rect2d.minPoint[0], pointsCollection.rect2d.minPoint[0]),
# 						   min(rect2d.minPoint[1], pointsCollection.rect2d.minPoint[1]))
# 			newMaxPoint = (max(rect2d.maxPoint[0], pointsCollection.rect2d.maxPoint[0]),
# 						   max(rect2d.maxPoint[1], pointsCollection.rect2d.maxPoint[1]))
# 			pointsCollection.rect2d.minPoint = newMinPoint
# 			pointsCollection.rect2d.maxPoint = newMaxPoint
# 		else:
# 			pointsCollection = DirectionalPoints2dCollection([], rect2d)
#
# 		random.seed(self.random_seed)
# 		for pointNb in range(self.total_points_to_place):
# 			if self.should_clump_towards_center:
# 				new_point_pos = (random.gauss((rect2d.minPoint[0] + rect2d.maxPoint[0]) / 2, rect2d.getWidth() / 8 / self.clumping_factor),
# 								 random.gauss((rect2d.minPoint[1] + rect2d.maxPoint[1]) / 2, rect2d.getHeight() / 8 / self.clumping_factor))
# 				# discard points outside of rect
# 				if new_point_pos[0] < rect2d.minPoint[0] or new_point_pos[0] >= rect2d.maxPoint[0] \
# 						or new_point_pos[1] < rect2d.minPoint[1] or new_point_pos[1] >= rect2d.maxPoint[1]:
# 					continue
# 				# discard points too close to borders
# 				if new_point_pos[0] < rect2d.minPoint[0] + self.safe_border_distance or new_point_pos[0] >= rect2d.maxPoint[0] - self.safe_border_distance or \
# 						new_point_pos[1] < rect2d.minPoint[1] + self.safe_border_distance or new_point_pos[1] >= rect2d.maxPoint[1] - self.safe_border_distance:
# 					continue
# 			else:
# 				new_point_pos = (random.uniform(rect2d.minPoint[0] + self.safe_border_distance, rect2d.maxPoint[0] - self.safe_border_distance),
# 								 random.uniform(rect2d.minPoint[1] + self.safe_border_distance, rect2d.maxPoint[1] - self.safe_border_distance))
#
# 			newPoint = DirectionalPoint2d(new_point_pos, random.uniform(0, math.pi))
# 			pointsCollection.points.append(newPoint)
# 		return pointsCollection
#
# 	def getRect2d(self):
# 		if self.rect2d_override_parent:
# 			return self.rect2d_override_parent
# 		if self.parent_generator:
# 			return self.parent_generator.getRect2d()
# 		return DirectionalPoint2dCollectionRandomGenerator.default_rect2d
#
#
# class DirectionalPoint2dCollectionRandomGeneratorNode(Node, Node):
# 	bl_label = 'Points 2d random generator'
# 	total_points_to_place = bpy.props.IntProperty(
# 		name='Total points to try to place',
# 		description='May be less if the generator cannot place all of them due to all the specified restriction',
# 		default=10, min=0)
# 	random_seed = bpy.props.IntProperty(
# 		name='Seed',
# 		description='Each value corresponds to a unique points arrangement',
# 		default=0)
# 	safe_border_distance = bpy.props.IntProperty(
# 		name='Min distance to borders',
# 		description='Safe minimum distance to borders',
# 		default=100, min=0)
# 	should_clump_towards_center = bpy.props.BoolProperty(
# 		name='Should clump towards center',
# 		description='If enabled, the points will clump. Otherwise they will be distributed uniformly',
# 		default=False)
# 	clumping_factor = bpy.props.FloatProperty(
# 		name='Clumping factor',
# 		description='How much clumping towards the center of the area',
# 		default=1, min=0.01)
# 	specific_rect_center = bpy.props.FloatVectorProperty(
# 		name='Area center',
# 		description='The (x,y) center location of the area over which the points will be placed',
# 		size=2,
# 		default=(0, 0))
# 	specific_rect_size = bpy.props.FloatVectorProperty(
# 		name='Area size',
# 		description='The size on X and Y axes of the area over which the points will be placed',
# 		size=2,
# 		default=(100, 100))
# 	should_use_specific_rect = bpy.props.BoolProperty(
# 		name='Specify area',
# 		description='If enabled the points will be restricted to the specified area. Otherwise they will be restricted to the same area as the previous points generator, or a default area if no previous generator.',
# 		default=False)
# 	pickled_DirectionalPoint2dCollection_getter = bpy.props.StringProperty()
#
# 	def init(self, context):
# 		self.width = 250
# 		self.inputs.new('DirectionalPoints2dCollectionSocket', 'Points 2d')
# 		self.outputs.new('DirectionalPoints2dCollectionSocket', 'Points 2d')
# 		self.random_seed = random.randint(-9999, 9999)
#
# 	def draw_buttons(self, context, layout):
# 		row = layout.row()
# 		row.prop(self, 'random_seed')
# 		source_node_path = 'bpy.data.node_groups["' + self.id_data.name + '"].' + self.path_from_id()
# 		op = row.operator('node.randomize_node_seed_operator')
# 		op.source_node_path = source_node_path
#
# 		layout.prop(self, 'total_points_to_place')
# 		layout.prop(self, 'safe_border_distance')
#
# 		layout.prop(self, 'should_clump_towards_center')
# 		if self.should_clump_towards_center:
# 			layout.prop(self, 'clumping_factor')
# 		layout.prop(self, 'should_use_specific_rect')
# 		if self.should_use_specific_rect:
# 			layout.prop(self, 'specific_rect_center')
# 			layout.prop(self, 'specific_rect_size')
#
# 	def update(self):
# 		generator = DirectionalPoint2dCollectionRandomGenerator()
# 		# generator.points_colorRGB = (random.uniform(.2, 1), random.uniform(.2, 1), random.uniform(.2, 1), 1)
# 		generator.total_points_to_place = self.total_points_to_place
# 		generator.safe_border_distance = self.safe_border_distance
# 		generator.random_seed = self.random_seed
# 		generator.should_clump_towards_center = self.should_clump_towards_center
# 		generator.clumping_factor = self.clumping_factor
# 		if self.should_use_specific_rect:
# 			specific_rect = Rect2d(None, None)
# 			specific_rect.setFromCenterAndSize(self.specific_rect_center, self.specific_rect_size)
# 			generator.rect2d_override_parent = specific_rect
# 		try:
# 			self.inputs['Points 2d'].links[0].from_node.update()
# 			generator.parent_generator = pickle.loads(eval(self.inputs['Points 2d'].links[0].from_node.pickled_DirectionalPoint2dCollection_getter))
# 		except:
# 			pass
# 		self.pickled_DirectionalPoint2dCollection_getter = str(pickle.dumps(generator))
#
#
# ######################################################################################################################################################################
#
# class DirectionalPoints2dCollectionDrawerOperator(bpy.types.Operator):
# 	bl_idname = 'node.directional_points2d_collection_drawer_op'
# 	bl_description = ''
# 	bl_label = 'Draw points'
# 	source_node_path = bpy.props.StringProperty()
#
# 	def execute(self, context):
# 		node_source = eval(self.source_node_path)
# 		node_source.update()
#
# 		imageName = 'Points'
#
# 		directionalPoint2dCollection_getter = None
# 		try:
# 			directionalPoint2dCollection_getter = pickle.loads(eval(node_source.pickled_DirectionalPoint2dCollection_getter))
# 		except:
# 			pass
# 		if directionalPoint2dCollection_getter:
# 			# met cette méthode en dehors du try pour avoir les erreurs s'il y en a pendant la génération
# 			pointsCollection = directionalPoint2dCollection_getter.get_DirectionalPoint2dCollection()
# 		else:
# 			return {'FINISHED'}
# 		rect2d = pointsCollection.rect2d
#
# 		try:
# 			image = bpy.data.images[imageName]
# 			image.scale(rect2d.getWidth(), rect2d.getHeight())
# 		except:
# 			image = bpy.data.images.new(imageName, rect2d.getWidth(), rect2d.getHeight(), alpha=True)
#
# 		bottomLeftPos = rect2d.minPoint
# 		pixels = [0 for i in range(image.size[0] * image.size[1] * 4)]
# 		for point in pointsCollection.points:
# 			point_pos_in_img = (math.floor(point.pos2d[0] - bottomLeftPos[0]), math.floor(point.pos2d[1] - bottomLeftPos[1]))
# 			définirPixel(pixels, image.size[0], point_pos_in_img[0], point_pos_in_img[1], (1, 1, 1, 1))
#
# 		image.pixels = pixels
# 		image.update()
# 		return {'FINISHED'}
#
#
# class DirectionalPoints2dCollectionDrawerNode(Node, Node):
# 	bl_label = 'Points 2d drawer'
# 	pickled_DirectionalPoint2dCollection_getter = bpy.props.StringProperty()
#
# 	def init(self, context):
# 		self.width = 200
# 		self.inputs.new('DirectionalPoints2dCollectionSocket', 'Points 2d')
#
# 	def draw_buttons(self, context, layout):
# 		source_node_path = 'bpy.data.node_groups["' + self.id_data.name + '"].' + self.path_from_id()
# 		op = layout.operator('node.directional_points2d_collection_drawer_op')
# 		op.source_node_path = source_node_path
#
# 	def update(self):
# 		pickled_DirectionalPoint2dCollection_getter = ""
# 		try:
# 			self.inputs['Points 2d'].links[0].from_node.update()
# 			self.pickled_DirectionalPoint2dCollection_getter = self.inputs['Points 2d'].links[0].from_node.pickled_DirectionalPoint2dCollection_getter
# 		except: pass
